<!DOCTYPE html>
<html>
<head>
  <title>Voice to Text Input (PHP Compatible)</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      padding: 30px;
    }
    input[type="text"] {
      width: 80%;
      padding: 10px;
      font-size: 18px;
    }
    button {
      padding: 10px 15px;
      font-size: 16px;
      margin-left: 10px;
    }
  </style>
</head>
<body>
  <h2>🎤 Speak and Convert to Text</h2>

  <form method="POST" action="save.php">
    <input type="text" id="speechInput" name="speechText" placeholder="Click 🎤 and start speaking..." required>
    <button type="button" id="startBtn">🎤</button>
    <button type="submit">Submit</button>
  </form>

  <script>
    // Check browser compatibility
    const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
    if (!SpeechRecognition) {
      alert("Speech recognition not supported in this browser. Use Chrome or Edge.");
    } else {
      const recognition = new SpeechRecognition();
      recognition.lang = 'en-IN'; // Set your preferred language (e.g. 'en-US', 'hi-IN', etc.)
      recognition.continuous = false;
      recognition.interimResults = false;

      const startBtn = document.getElementById('startBtn');
      const input = document.getElementById('speechInput');

      startBtn.onclick = () => {
        recognition.start();
        startBtn.textContent = "🎙️ Listening...";
      };

      recognition.onresult = (event) => {
        const text = event.results[0][0].transcript;
        input.value = text;
        startBtn.textContent = "🎤";
      };

      recognition.onerror = (event) => {
        console.error(event.error);
        startBtn.textContent = "🎤";
      };

      recognition.onend = () => {
        startBtn.textContent = "🎤";
      };
    }
  </script>
</body>
</html>