<?php
header("Content-Type: application/json");
// include("../test.php");
include ("../opendb.php");

// $cd = $_REQUEST['cd'];
// $brcode = 'BLRACC';

$cd = $_GET['cd'];
$brcode = $_GET['brcode'];

// ---------------------------
// FETCH OPENING BALANCE
// ---------------------------
$sql = "SELECT * FROM ledger WHERE led='$cd' AND brcode='$brcode'";
$res = mysqli_query($db, $sql);
$opb = mysqli_fetch_array($res);

$data = [];
$data["customer"] = $cd;

// Determine opening balance
$opening = [];
$opening["drcr"]  = strtoupper($opb["drcr"]);
$opening["amount"] = floatval($opb["op"]);

$data["opening_balance"] = $opening;

// Internal totals
$tr = 0;   // debit total
$tp = 0;   // credit total

// Apply opening to totals
if ($opening["drcr"] == "DR") {
    if ($opening["amount"] >= 0) { $tr += $opening["amount"]; }
    else { $tp += abs($opening["amount"]); }
} else { // CR
    if ($opening["amount"] >= 0) { $tp += $opening["amount"]; }
    else { $tr += abs($opening["amount"]); }
}

function datetoHtml($d)
{
 $ar=explode("-",$d);
 $var=$ar[2]."-".$ar[1]."-".$ar[0];
 return $var;
}

// ---------------------------
// FETCH JOURNAL ENTRIES
// ---------------------------
$sql = "SELECT * FROM journal2 
        WHERE brcode='$brcode' 
          AND partic='$cd'
        ORDER BY date, jvno";

$result = mysqli_query($db, $sql);
$transactions = [];

while ($row = mysqli_fetch_array($result)) {

    $entry = [];
    $entry["date"] = datetohtml($row["date"]);
    $entry["jvno"] = $row["jvno"];
    $entry["narr"] = $row["narr"];
    $entry["type"] = $row["type"];
    $entry["j_type"] = $row["j_type"];
    
    // ---------------------
    // CREDIT ENTRY
    // ---------------------
    if ($row["type"] == "Cr") {

        $entry["amount_dr"] = 0;
        $entry["amount_cr"] = floatval($row["cramt"]);

        $tp += $row["cramt"];         // increase credit
        $s = $tr - $tp;               // balance

        $entry["balance_after"] = round($s, 2);

        // Fetch special reference for Spare Purchase
        if ($row["j_type"] == "Spare Pur") {
            $r121 = mysqli_query($db, "SELECT ref FROM sparepurchase 
                                       WHERE brcode='$brcode' 
                                         AND jvno={$row['jvno']}");
            $trow121 = mysqli_fetch_array($r121);
            $entry["ref"] = $trow121[0];
        } else {
            $entry["ref"] = "";
        }

        // Sales Return print link
        if ($row["j_type"] == "Sales Return") {
            $invno = substr($row["narr"], 16, 30);
        
            $temp_query = mysqli_query($db, "SELECT temp_code FROM temp_code_invno_brcode WHERE invno='$invno' AND brcode='$brcode' LIMIT 1");
            $temp_querydata = mysqli_fetch_assoc($temp_query);
        
            if (!empty($temp_querydata)) {
                $temp_code = $temp_querydata['temp_code'];
            } else {
        
                $temp_code = bin2hex(random_bytes(8));
                $rnquery = "INSERT INTO temp_code_invno_brcode (`temp_code`, `invno`, `brcode`) VALUES ('$temp_code', '$invno', '$brcode')";
                mysqli_query($db, $rnquery);
            }
        
            $entry["print_link"] = "https://psnautos.in/force2526/spares/salesret_printprn_api_test_2.php?code=$temp_code";
        } else {
            $entry["print_link"] = "";
        }
    }

    // ---------------------
    // DEBIT ENTRY
    // ---------------------
    else {

        $entry["amount_dr"] = floatval($row["dramt"]);
        $entry["amount_cr"] = 0;

        $tr += $row["dramt"];         // increase debit
        $s = $tr - $tp;               // balance

        $entry["balance_after"] = round($s, 2);

        // Track spare invoice info
        if ($row["j_type"] == "Spare Invoice") {

            // get partcode
            $sqlpart = "SELECT partcode FROM spareinvoice 
                        WHERE brcode='$brcode' 
                          AND jvno='{$row['jvno']}' 
                        LIMIT 1";
            $respart = mysqli_query($db, $sqlpart);
            $rowpart = mysqli_fetch_array($respart);

            $sqlmanu = "SELECT group1, manufacturer 
                        FROM partmaster 
                        WHERE partcode='{$rowpart[0]}' 
                        LIMIT 1";
            $resmanu = mysqli_query($db, $sqlmanu);
            $rowmanu = mysqli_fetch_array($resmanu);

            $entry["manufacturer"] =
                strlen($rowmanu[0]) > 0
                ? $rowmanu[0] . " - " . $rowmanu[1]
                : "";
        }
        
        // Invoice print link
        if ($row["j_type"] == "Spare Invoice") {
            $invno = substr($row["narr"], 13, 30);

            if ($brcode == 'BLRACC' || $brcode == 'HUBACC' || $brcode == 'HYDACC'){
                $temp_query = mysqli_query($db, "SELECT * FROM temp_code_invno_brcode WHERE invno='$invno' AND brcode='$brcode'");
                $temp_querydata  = mysqli_fetch_array($temp_query);
                
                if(!empty($temp_querydata)){
                    $temp_code = $temp_querydata['temp_code'];
                    // $entry["print_link"] = "https://psnautos.in/force2526/prnspareinvoice_dup22022025_api_test_2.php?code=$temp_code";
                }else{
                    $temp_code = bin2hex(random_bytes(8));
                    $rnquery = "INSERT INTO temp_code_invno_brcode (`temp_code`, `invno`, `brcode`) VALUES ('$temp_code', '$invno', '$brcode')";
                    mysqli_query($db, $rnquery);
                }
                $entry["print_link"] = "https://psnautos.in/force2526/prnspareinvoice_dup22022025_api_test_2.php?code=$temp_code";
            }else{
                $temp_query = mysqli_query($db, "SELECT * FROM temp_code_invno_brcode WHERE invno='$invno' AND brcode='$brcode'");
                $temp_querydata  = mysqli_fetch_array($temp_query);
                
                if(!empty($temp_querydata)){
                    $temp_code = $temp_querydata['temp_code'];
                }else{
                    $temp_code = bin2hex(random_bytes(8));
                    $rnquery = "INSERT INTO temp_code_invno_brcode (`temp_code`, `invno`, `brcode`) VALUES ('$temp_code', '$invno', '$brcode')";
                    mysqli_query($db, $rnquery);
                    // $entry["print_link"] = "https://psnautos.in/force2526/spares/salesret_printprn_api_test_2.php?code=$temp_code";
                }
                $entry["print_link"] = "https://psnautos.in/force2526/spares/salesret_printprn_api_test_2.php?code=$temp_code";
                
            }
        } else {
            $entry["print_link"] = "";
        }
    }

    $transactions[] = $entry;
}

$data["transactions"] = $transactions;

// ---------------------------
// TOTALS + FINAL BALANCE
// ---------------------------
$totals = [];
$totals["total_debit"]  = round($tr, 2);
$totals["total_credit"] = round($tp, 2);

$data["totals"] = $totals;

$bal = $tr - $tp;

$data["final_balance"] = [
    "balance"      => round(abs($bal), 2),
    "balance_type" => $bal >= 0 ? "Debit" : "Credit"
];

// OUTPUT JSON
echo json_encode($data);
?>