<?php
session_start();
include("opendb.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login - PSN AUTOMOTIVE MARKETING PVT LTD</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(120deg, #2c3e50, #3498db);
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      overflow: hidden;
    }
    body::before {
      content: "";
      position: absolute;
      top: -50%;
      left: -50%;
      width: 200%;
      height: 200%;
      background-image: radial-gradient(#ffffff22 1px, transparent 1px);
      background-size: 40px 40px;
      animation: moveBg 30s linear infinite;
      z-index: 0;
    }
    .bubbles {
      position: absolute;
      width: 100%;
      height: 100%;
      z-index: 0;
      overflow: hidden;
    }
    .bubble {
      position: absolute;
      bottom: -100px;
      background: rgba(255, 255, 255, 0.2);
      border-radius: 50%;
      animation: floatBubbles 20s infinite ease-in;
    }
    @keyframes floatBubbles {
      0% {
        transform: translateY(0) scale(1);
        opacity: 1;
      }
      100% {
        transform: translateY(-110vh) scale(1.5);
        opacity: 0;
      }
    }
    .login-container {
      position: relative;
      z-index: 1;
      /* background: #ffffff; */
      background: #ffffff40;
      padding: 1.5rem;
      border-radius: 12px;
      box-shadow: 0 0 20px rgba(0, 0, 0, 0.3);
      max-width: 350px;
      width: 100%;
    }
    .login-container h2 {
      text-align: center;
      margin-bottom: 1rem;
      color: white;
      font-size: 1.1rem;
    }
    .login-container select,
    .login-container input,
    .login-container button {
      width: 100%;
      padding: 8px 10px;
      margin: 8px 0;
      border-radius: 6px;
      border: 1px solid #ccc;
      font-size: 0.95rem;
      box-sizing: border-box;
    }
    .login-container select {
      background-color: #f8f9fa;
      height: 38px;
    }
    .login-container input {
      height: 38px;
    }
    .login-container button {
      background-color:rgb(21, 124, 192);
      color: white;
      border: none;
      cursor: pointer;
      font-weight: bold;
      height: 40px;
    }
    .login-container button:hover {
      background-color:rgb(9, 94, 151);
    }

    .bg-watermark {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    font-size: 36vw;
    font-weight: bold;
    /* color: rgba(255, 255, 255, 0.13); */
    color: rgba(182 191 255 / 13%);
    z-index: 0; 
    user-select: none;
    pointer-events: none;
    letter-spacing: 1vw;
    }

    .footer {
      display: flex;
      flex-direction: column;
      text-align: center;
      margin-top: 1rem;
      font-size: 0.85rem;
      color: #d7d2d2;
    }
    .footer a {
      color: #cddfeb;
      text-decoration: none;
    }
  </style>

  <script>
    //  key prevention here
    document.addEventListener("contextmenu", e => e.preventDefault());
    document.addEventListener("keydown", e => {
      if (e.key === "F12" ||
         (e.ctrlKey && e.shiftKey && ["I", "J", "C"].includes(e.key)) ||
         (e.ctrlKey && e.key === "U")) {
        e.preventDefault();
      }
    });


    $(function () {
      const setupDatepicker = (finYear) => {
        const parts = finYear.split("-");
        const startDate = `${parts[0]}-04-01`;
        const endDate = `20${parts[1]}-03-31`;
        $("#datepicker").datepicker("destroy").datepicker({
          minDate: startDate,
          maxDate: endDate
        });
      };

      setupDatepicker($("#fin_yr").val());

      $("#fin_yr").on("change", function () {
        setupDatepicker(this.value);
      });

    //   floating bubble section here
      const bubbleContainer = $('<div class="bubbles"></div>').appendTo('body');
      for (let i = 0; i < 15; i++) {
        const size = Math.random() * 80 + 10;
        const left = Math.random() * 100;
        const duration = Math.random() * 20 + 10;
        $('<div class="bubble"></div>').css({
          width: size,
          height: size,
          left: `${left}%`,
          animationDuration: `${duration}s`
        }).appendTo(bubbleContainer);
      }
    });

    function valid() {
      const f = document.f;
      if (f.branchcde.selectedIndex <= 0) {
        alert('Invalid Branch'); return false;
      }
      if (f.uname.value.trim().length <= 0) {
        alert('Invalid Username'); return false;
      }
      if (f.pswd.value.trim().length <= 0) {
        alert('Invalid Password'); return false;
      }
    }
  </script>
</head>

<body onload="document.f.branchcde.focus()">
  <div class="bg-watermark"><i>PSN</i></div>
  <form name='f' action='login.php' method='post' onsubmit="return valid()">
    <div class="login-container">
      <h2>PSN AUTOMOTIVE MARKETING PVT LTD</h2>

      <select name='fin_yr' id="fin_yr">
        <option value="2025-26">2025-26</option>
      </select>

      <input type="text" id="datepicker" name="login_date" value="<?php echo date('Y-m-d'); ?>" readonly />

      <select name='branchcde' id="brch">
        <option>-select-</option>
        <?php
        $re = mysqli_query($db, "select brcode, brname from branch order by brname") or die(mysqli_error());
        while ($row = mysqli_fetch_array($re)) 
        {
          echo "<option value='{$row['brcode']}'>{$row['brname']}</option>";
        }
        ?>
      </select>

      <input type="text" name="uname" placeholder="Username" id="username">
      <input type="password" name="pswd" placeholder="Password" id="password">
      <button type="submit">Login</button>

      <div class="footer">
        Maintained by <a href='http://www.psninfotech.com' target='_blank'>Psn Infotech</a>
        <span id="siteseal"><script async type="text/javascript" src="https://seal.godaddy.com/getSeal?sealID=pt09kTSsmN26mOf3ww81WLfFQZIDHjiKavAicLEgLJLtbOevdsVfokXsSABU"></script></span>
      </div>
      
    </div>
    
  </form>
</body>
</html>
