<?php
// genpdf3_portrait.php - Portrait A4 FPDF invoice generator (rewritten for readability)
session_start();
include("../opendb.php");
include("../test.php");
require("fpdf.php");

$invno = $_REQUEST['invno'] ?? '';
$brcode = $_REQUEST['brcode'] ?? '';

if ($invno === '') {
    die("Missing invno");
}

/* ------------------ Fetch DB rows (reuse original logic) ------------------ */
$re = mysqli_query($db, "SELECT * FROM spareinvoice WHERE invno='".mysqli_real_escape_string($db,$invno)."' AND brcode='".mysqli_real_escape_string($db,$brcode)."'");
if (!$re || mysqli_num_rows($re) <= 0) {
    die("Invoice No does not exist");
}

$query1 = mysqli_query($db, "SELECT acfrom, acto FROM acperiod");
$per_row = mysqli_fetch_array($query1);

$jcrow = mysqli_fetch_array($re);
$maddr = $jcrow['addr'];

$foc = $_REQUEST['foc'] ?? '';
$invtype = $_REQUEST['invtype'] ?? '';

if ($foc == 'foc') {
    $re = mysqli_query($db, "select * from spareinvoicefoc where invno='".mysqli_real_escape_string($db,$invno)."' and invtype='".mysqli_real_escape_string($db,$invtype)."' and brcode='".mysqli_real_escape_string($db,$brcode)."'") or die('err:' . mysqli_error($db));
} else {
    $re = mysqli_query($db, "select * from spareinvoice where invno='".mysqli_real_escape_string($db,$invno)."' and brcode='".mysqli_real_escape_string($db,$brcode)."'") or die(mysqli_error($db));
}
$row = mysqli_fetch_array($re) or die("Fetch Error:" . mysqli_error($db));
if ($row['entrydate'] > $per_row[1] || $row['entrydate'] < $per_row[0]) {
    die("Invoice not in this financial year !!!!!");
}

$brres = mysqli_query($db, "select * from branch where brcode='".mysqli_real_escape_string($db,$brcode)."'");
$brrow = mysqli_fetch_array($brres);

$cusres = mysqli_query($db, "select * from customer where acname='".mysqli_real_escape_string($db,$row['customer'])."' and brcode='".mysqli_real_escape_string($db,$brcode)."'");
$cusrow = mysqli_fetch_array($cusres);

$qrqry = mysqli_query($db, "select * from tbl_einvoice where invno='".mysqli_real_escape_string($db,$row['invno'])."' and brcode='".mysqli_real_escape_string($db,$brcode)."'");
$qrrow = mysqli_fetch_array($qrqry);
$signedqr = $qrrow['SignedQRCode'] ?? '';
$irn = $qrrow['irnno'] ?? '';

/* Fetch items and compute totals */
$res = mysqli_query($db, "select * from spareinvoice where invno='".mysqli_real_escape_string($db,$invno)."' and brcode='".mysqli_real_escape_string($db,$brcode)."'") or die(mysqli_error($db));
$items = [];
$partstotal = 0;
$total_disc = 0;
$totcshdis = 0;
$sgst_tot = 0;
$cgst_tot = 0;
$igst_tot = 0;
$qty_tot = 0;
$rate_tot = 0;
$i = 0;
while ($res1 = mysqli_fetch_assoc($res)) {
    $i++;
    $it = [];
    $it['slno'] = $i;
    $it['partcode'] = $res1['partcode'];
    $it['partname'] = $res1['partname'];
    $it['qty'] = $res1['qty'];
    $it['price'] = $res1['price'];
    $it['qtyprcamt'] = $res1['qty'] * $res1['price'];
    $partstotal += $it['qtyprcamt'];
    $it['disc'] = $res1['disc'];
    $it['discamt'] = ($it['qtyprcamt']) * $res1['disc'] / 100.0;
    $total_disc += $it['discamt'];
    $afterdis = $it['qtyprcamt'] - $it['discamt'];
    $it['cshdisc'] = $res1['cshdisc'];
    $it['cashdisamt'] = $afterdis * ($res1['cshdisc'] / 100.0);
    $totcshdis += $it['cashdisamt'];
    $qty_tot += $it['qty'];
    $rate_tot += $it['price'];

    // mrp and hsn lookup (best-effort)
    if ($brcode == 'YES001') {
        $sprqry = "select mrp from spareprmast_retail where partcode = '{$it['partcode']}' order by effectfrom desc limit 1";
    } else {
        $sprqry = "select mrp from spareprmast where partcode = '{$it['partcode']}' order by effectfrom desc limit 1";
    }
    $sprres = mysqli_query($db, $sprqry);
    $sprrow = mysqli_fetch_row($sprres);
    $it['mrp'] = $sprrow[0] ?? '';

    if ($brcode == 'YES001')
        $qry = "select location from  partmaster_retail where partcode='{$it['partcode']}'";
    else
        $qry = "select location from partmaster where partcode='{$it['partcode']}'";

    $rsqr = mysqli_query($db, $qry);
    $rsrw = mysqli_fetch_array($rsqr);
    $it['hsn'] = strlen($rsrw[0]) ? $rsrw[0] : '0';

    if ($row['vatorcst'] == 'INTRASTATE') {
        $it['cgstp'] = $res1['cgstp'];
        $it['sgstp'] = $res1['sgstp'];
        $it['cgstamt'] = $res1['cgstamt'];
        $it['sgstamt'] = $res1['sgstamt'];
        $sgst_tot += $res1['sgstamt'];
        $cgst_tot += $res1['cgstamt'];
        $it['taxable'] = $res1['aprice'];
    } else {
        $it['igstp'] = $res1['igstp'];
        $it['igstamt'] = $res1['igstamt'];
        $igst_tot += $res1['igstamt'];
        $it['taxable'] = $res1['aprice'];
    }

    $it['tot'] = $res1['tot'];
    $jtot+=$res1['tot'];
    $items[] = $it;
}

/* Helper formatting functions */
// function putcoma($num) {
//     return number_format((float)$num, 2, '.', ',');
// }

function numToWords($num) {
    $num = (int) round($num);
    if ($num === 0) return 'Zero';
    $ones = ['', 'One','Two','Three','Four','Five','Six','Seven','Eight','Nine','Ten','Eleven','Twelve','Thirteen','Fourteen','Fifteen','Sixteen','Seventeen','Eighteen','Nineteen'];
    $tens = ['', '', 'Twenty','Thirty','Forty','Fifty','Sixty','Seventy','Eighty','Ninety'];
    $units = ['', 'Thousand', 'Lakh', 'Crore'];
    $parts = [];
    $hundreds = $num % 1000;
    if ($hundreds) $parts[] = convertThreeDigit($hundreds);
    $num = intdiv($num, 1000);
    $unitIdx = 1;
    while ($num > 0) {
        $group = $num % 100;
        if ($group) {
            $prefix = convertTwoDigit($group);
            $parts[] = $prefix . ' ' . ($units[$unitIdx] ?? '');
        }
        $num = intdiv($num, 100);
        $unitIdx++;
    }
    return trim(implode(' ', array_reverse(array_filter(array_map('trim', $parts)))));
}
function convertThreeDigit($n) {
    $ones = ['', 'One','Two','Three','Four','Five','Six','Seven','Eight','Nine','Ten','Eleven','Twelve','Thirteen','Fourteen','Fifteen','Sixteen','Seventeen','Eighteen','Nineteen'];
    $tens = ['', '', 'Twenty','Thirty','Forty','Fifty','Sixty','Seventy','Eighty','Ninety'];
    $out = '';
    if ($n >= 100) {
        $out .= $ones[intval($n / 100)] . ' Hundred ';
        $n = $n % 100;
    }
    if ($n > 0) {
        if ($n < 20) $out .= $ones[$n];
        else $out .= $tens[intval($n / 10)] . ' ' . $ones[$n % 10];
    }
    return trim($out);
}
function convertTwoDigit($n) {
    $ones = ['', 'One','Two','Three','Four','Five','Six','Seven','Eight','Nine','Ten','Eleven','Twelve','Thirteen','Fourteen','Fifteen','Sixteen','Seventeen','Eighteen','Nineteen'];
    $tens = ['', '', 'Twenty','Thirty','Forty','Fifty','Sixty','Seventy','Eighty','Ninety'];
    if ($n < 20) return $ones[$n];
    return $tens[intval($n / 10)] . ' ' . $ones[$n % 10];
}

/* FPDF layout & drawing - Portrait A4 */
class PDF extends FPDF {
    function Footer() {
        $this->SetY(-12);
        $this->SetFont('Arial', '', 8);
        $this->Cell(0, 6, 'Page '.$this->PageNo().'/{nb}', 0, 0, 'R');
    }
}

$pdf = new PDF('P', 'mm', 'A4');
$pdf->AliasNbPages();
$pdf->SetAutoPageBreak(false);
$margin = 8;
$pdf->SetMargins($margin, $margin, $margin);
$leftMargin = $margin; $rightMargin = $margin; $topMargin = $margin;
$pdf->SetFont('Arial', '', 9);

/* Pre-download QR using cURL */
$qr_temp = '';
if (!empty($signedqr)) {
    $qr_url = "https://qrcode.tec-it.com/API/QRCode?size=small&dpi=150&data=" . urlencode($signedqr);
    $qr_temp = sys_get_temp_dir() . '/qr_' . md5($signedqr) . '.png';
    $ch = curl_init($qr_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $qr_data = curl_exec($ch);
    $http_status = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
    curl_close($ch);
    if ($qr_data !== false && $http_status >= 200 && $http_status < 300) {
        file_put_contents($qr_temp, $qr_data);
    } else {
        $qr_temp = '';
    }
}

/* Column widths (portrait usable width = 210 - 16 = 194 mm) */
/* Chosen widths are compact to include all columns while keeping text readable */
$col = [
    'sl' => 6,
    'partcode' => 16,   // 24
    'partname' => 32,   // 64
    'hsn' => 13,        // 74
    'qty' => 8,         // 82
    'rate' => 12,       // 96
    'mrp' => 12,        // 106
    'disc%' => 10,       // 112
    'discamt' => 15,    // 124
    'cashdisc' => 10,   // 134
    'taxable' => 13,    // 148
    'tax1p' => 8,       // 154
    'tax1amt' => 12,    // 166
    'tax2p' => 7,       // 172 (for intrastate)
    'tax2amt' => 12,    // 184
    'total' => 14       // 194 (fits exactly)
];

if(count($items)>4){
    $limit = count($items);
}else{
    $limit = 4;
}
 // rows per page for portrait readability
$total_items = count($items);
$pg_no = max(0, (int) floor(($total_items - 1) / $limit));

for ($p = 0; $p <= $pg_no; $p++) {
    $pdf->AddPage();
    $pdf->SetFont('Arial', '', 9);

    // Header: logo centered, IRN left, QR top-right
    // $logo_path = __DIR__ . '../images/autospec_logo.jpeg';
    // if (file_exists($logo_path)) {
        $pdf->Image('../images/autospec_logo.jpeg', ($pdf->GetPageWidth() - 190) / 2, 8, 50);
    // }
    $pdf->SetY(18);
    if (!empty($irn)) {
        $pdf->SetX($leftMargin);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(100, 5, "IRN: $irn", 0, 1);
    }
    if (!empty($qr_temp) && file_exists($qr_temp)) {
        $pdf->Image($qr_temp, $pdf->GetPageWidth() - $rightMargin - 32, 8, 32, 32);
    }

    // Title row
    $pdf->SetY(42);
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->SetX($leftMargin);
    
    // Left cell: INVNO
    $pdf->Cell(66, 8, "INVNO: " . $invno, 1, 0, 'L');
    
    // Middle cell: FORM GST INV - 1
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->Cell(
        $pdf->GetPageWidth() - $leftMargin - $rightMargin - 40 - 70, // middle width
        8,
        "FORM GST INV - 1",
        1,
        0,
        'C'
    );
    
    // Right cell: INVDT
    $pdf->SetFont('Arial', '', 9);
    $invdt = date('d-m-Y', strtotime($row['entrydate']));
    $pdf->Cell(50, 8, "INVDT: $invdt", 1, 1, 'R');

    // Billed to and Consignee boxes
    $pdf->Ln(2);
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->SetX($leftMargin);
    $pdf->Cell(100, 6, 'Details of Receiver (Billed to)', 1, 0, 'L');
    $pdf->Cell(100, 6, 'Details of Consignee (Shipped to)', 1, 1, 'L');

    $pdf->SetFont('Arial', '', 8);
    $billing = $row['customer'] . "\n" . ($row['addr1'] ? $row['addr1'] : $maddr);
    if (!empty($cusrow['pin1'])) $billing .= " PIN:" . $cusrow['pin1'];
    if (!empty($cusrow['phone1'])) $billing .= " PHONE:" . $cusrow['phone1'];
    $leftBox = "Name : " . $row['customer'] . "\nAddress : " . $billing . "\nState : " . ($cusrow['state1'] ?: $row['invtype']) . "\nGSTIN : " . ($cusrow['gst'] ?: '') . "\nPAN : " . ($cusrow['cst'] ?: '');
    $pdf->SetX($leftMargin);
    $pdf->MultiCell(100, 5, $leftBox, 1);
    $curY = $pdf->GetY();
    $pdf->SetXY($leftMargin + 100, $curY - 35 - (count(explode("\n",$leftBox))*0)); // place in same baseline
    $pdf->MultiCell(100, 5, $leftBox, 1);

    $pdf->Ln(2);

    // Items table header
    $pdf->SetFont('Arial', 'B', 7);
    $startX = $leftMargin;
    $pdf->SetX($startX);
    $pdf->Cell($col['sl'], 8, 'SL', 1, 0, 'C');
    $pdf->Cell($col['partcode'], 8, 'PARTCODE', 1, 0, 'C');
    $pdf->Cell($col['partname'], 8, 'PART NAME', 1, 0, 'C');
    $pdf->Cell($col['hsn'], 8, 'HSN', 1, 0, 'C');
    $pdf->Cell($col['qty'], 8, 'QTY', 1, 0, 'C');
    $pdf->Cell($col['rate'], 8, 'RATE', 1, 0, 'C');
    $pdf->Cell($col['mrp'], 8, 'MRP', 1, 0, 'C');$x = $pdf->GetX();
    $y = $pdf->GetY();
    
    $w = $col['disc%'];
    $h = 8;
    
    // Draw border manually
    $pdf->Rect($x, $y, $w, $h);
    
    // Write text with % on new line
    $pdf->SetXY($x, $y + 1); 
    $pdf->SetFont('Arial', 'B', 7); 
    $pdf->MultiCell($w, 3.5, "DISC\n%", 0, 'C');
    
    // Move cursor to the right for next cell
    $pdf->SetXY($x + $w, $y);
    
    //////////////////////////////////
    
    $x = $pdf->GetX();
    $y = $pdf->GetY();
    
    $w = $col['discamt'];
    $h = 8;
    
    // Draw border manually
    $pdf->Rect($x, $y, $w, $h);
    
    // Write text with % on new line
    $pdf->SetXY($x, $y + 1); 
    $pdf->SetFont('Arial', 'B', 7); 
    $pdf->MultiCell($w, 3.5, "DISC\nAMT", 0, 'C');
    
    // Move cursor to the right for next cell
    $pdf->SetXY($x + $w, $y);
    // $pdf->Cell($col['discamt'], 8, 'DISC AMT', 1, 0, 'C');
    
    /////////////////////////////////////////////////////////////
    
    $x = $pdf->GetX();
    $y = $pdf->GetY();
    
    $w = $col['cashdisc'];
    $h = 8;
    
    // Draw border manually
    $pdf->Rect($x, $y, $w, $h);
    
    // Write text with % on new line
    $pdf->SetXY($x, $y + 1); 
    $pdf->SetFont('Arial', 'B', 7); 
    $pdf->MultiCell($w, 3.5, "CASH\nDISC", 0, 'C');
    
    // Move cursor to the right for next cell
    $pdf->SetXY($x + $w, $y);
    // $pdf->Cell($col['discamt'], 8, 'DISC AMT', 1, 0, 'C');
    
    ///////////////////////////////////////////////////////////////
    
    // $pdf->Cell($col['cashdisc'], 8, 'CASH DISC', 1, 0, 'C');
    $pdf->Cell($col['taxable'], 8, 'TAXABLE', 1, 0, 'C');

    if ($row['vatorcst'] == 'INTRASTATE') {
        $x = $pdf->GetX();
        $y = $pdf->GetY();
        
        $w = $col['tax1p'];
        $h = 8;
        
        // Draw border manually
        $pdf->Rect($x, $y, $w, $h);
        
        // Write text with % on new line
        $pdf->SetXY($x, $y + 1); 
        $pdf->SetFont('Arial', 'B', 7); 
        $pdf->MultiCell($w, 3.5, "CGST%", 0, 'C');
        
        // Move cursor to the right for next cell
        $pdf->SetXY($x + $w, $y);
        ////////////////////////////////////////
        $x = $pdf->GetX();
        $y = $pdf->GetY();
        
        $w = $col['tax1amt'];
        $h = 8;
        
        // Draw border manually
        $pdf->Rect($x, $y, $w, $h);
        
        // Write text with % on new line
        $pdf->SetXY($x, $y + 1); 
        $pdf->SetFont('Arial', 'B', 7); 
        $pdf->MultiCell($w, 3.5, "CGST\nAMT", 0, 'C');
        
        // Move cursor to the right for next cell
        $pdf->SetXY($x + $w, $y);
        ////////////////////////////////////////
        
        $x = $pdf->GetX();
        $y = $pdf->GetY();
        
        $w = $col['tax2p'];
        $h = 8;
        
        // Draw border manually
        $pdf->Rect($x, $y, $w, $h);
        
        // Write text with % on new line
        $pdf->SetXY($x, $y + 1); 
        $pdf->SetFont('Arial', 'B', 7); 
        $pdf->MultiCell($w, 3.5, "SGST%", 0, 'C');
        
        // Move cursor to the right for next cell
        $pdf->SetXY($x + $w, $y);
        ///////////////////////////////////////////////
        $x = $pdf->GetX();
        $y = $pdf->GetY();
        
        $w = $col['tax2amt'];
        $h = 8;
        
        // Draw border manually
        $pdf->Rect($x, $y, $w, $h);
        
        // Write text with % on new line
        $pdf->SetXY($x, $y + 1); 
        $pdf->SetFont('Arial', 'B', 7); 
        $pdf->MultiCell($w, 3.5, "SGST\nAMT", 0, 'C');
        
        // Move cursor to the right for next cell
        $pdf->SetXY($x + $w, $y);
        
        
        // $pdf->Cell($col['tax1p'], 8, 'CGST%', 1, 0, 'C');
        // $pdf->Cell($col['tax1amt'], 8, 'CGST AMT', 1, 0, 'C');
        // $pdf->Cell($col['tax2p'], 8, 'SGST%', 1, 0, 'C');
        // $pdf->Cell($col['tax2amt'], 8, 'SGST AMT', 1, 0, 'C');
    } else {
        $pdf->Cell($col['tax1p'], 7, 'IGST%', 1, 0, 'C');
        $pdf->Cell($col['tax1amt'], 8, 'IGST AMT', 1, 0, 'C');
    }
    $pdf->Cell($col['total'], 8, 'TOTAL', 1, 1, 'C');

    // Items rows
    $pdf->SetFont('Arial', '', 7);
    $start = $p * $limit;
    for ($r = 0; $r < $limit; $r++) {
        $k = $start + $r;
        $isEmpty = ($k >= $total_items);
        $it = $isEmpty ? null : $items[$k];

        $pdf->SetX($startX);
        $pdf->Cell($col['sl'], 7, $isEmpty ? '' : $it['slno'], 1, 0, 'C');
        $pdf->Cell($col['partcode'], 7, $isEmpty ? '' : $it['partcode'], 1, 0);
        $pdf->Cell($col['partname'], 7, $isEmpty ? '' : substr($it['partname'], 0, 55), 1, 0);
        $pdf->Cell($col['hsn'], 7, $isEmpty ? '' : $it['hsn'], 1, 0, 'C');
        $pdf->Cell($col['qty'], 7, $isEmpty ? '' : $it['qty'], 1, 0, 'R');
        $pdf->Cell($col['rate'], 7, $isEmpty ? '' : putcoma($it['price']), 1, 0, 'R');
        $pdf->Cell($col['mrp'], 7, $isEmpty ? '' : $it['mrp'], 1, 0, 'R');
        $pdf->Cell($col['disc%'], 7, $isEmpty ? '' : $it['disc'], 1, 0, 'R');
        $pdf->Cell($col['discamt'], 7, $isEmpty ? '' : putcoma($it['discamt']), 1, 0, 'R');
        $pdf->Cell($col['cashdisc'], 7, $isEmpty ? '' : putcoma($it['cashdisamt']), 1, 0, 'R');
        $pdf->Cell($col['taxable'], 7, $isEmpty ? '' : putcoma($it['taxable']), 1, 0, 'R');

        if ($row['vatorcst'] == 'INTRASTATE') {
            $pdf->Cell($col['tax1p'], 7, $isEmpty ? '' : ($it['cgstp'] ?? ''), 1, 0, 'R');
            $pdf->Cell($col['tax1amt'], 7, $isEmpty ? '' : putcoma($it['cgstamt'] ?? 0), 1, 0, 'R');
            $pdf->Cell($col['tax2p'], 7, $isEmpty ? '' : ($it['sgstp'] ?? ''), 1, 0, 'R');
            $pdf->Cell($col['tax2amt'], 7, $isEmpty ? '' : putcoma($it['sgstamt'] ?? 0), 1, 0, 'R');
        } else {
            $pdf->Cell($col['tax1p'], 7, $isEmpty ? '' : ($it['igstp'] ?? ''), 1, 0, 'R');
            $pdf->Cell($col['tax1amt'], 7, $isEmpty ? '' : putcoma($it['igstamt'] ?? 0), 1, 0, 'R');
        }

        $pdf->Cell($col['total'], 7, $isEmpty ? '' : putcoma($it['tot']), 1, 1, 'R');
    }
    
    // ==== FOOTER (HTML EXACT REPLICA) ====
    
    // Fixed footer Y position
    $footerY = 200;

    // $pdf->Rect($leftMargin, $pdf->GetY() , 250, 8); 
    
    // RESET XY to left margin to avoid drift
    $pdf->SetXY($leftMargin, $footerY);
    
    // DSR + PREPARED BY row
    $pdf->SetFont('Arial', '', 7);
    $pdf->Cell(90, 6, 'DSR : ' . ($row['engineer'] ?? ''), 0, 0, 'L');
    
    $pre_by1 = explode('|', $row['ref'] ?? '');
    $pre_by = $pre_by1[1] ?? '';
    $pdf->Cell(90, 6, 'PREPARED BY : ' . trim($pre_by), 0, 1, 'L');
    
    /* FIXED WIDTHS — DO NOT CHANGE */
    $leftBlockW  = 106;
    $rightBlockW = 90;
    $gap = 6;
    
    $baseY = $pdf->GetY();
    $pdf->Rect($leftMargin, $baseY , $leftBlockW, 80); 
    
    /**************************************
     * LEFT SIDE FOOTER BLOCK
     **************************************/
    $pdf->SetXY($leftMargin, $baseY);
    
    // TITLE
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell($leftBlockW, 5, "PSN AUTOMOTIVE MARKETING PRIVATE LIMITED", 0, 1, 'L');
    
    // ADDRESS
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetX($leftMargin);
    $pdf->MultiCell(
        $leftBlockW,
        4,
        ($brrow['braddr'] ?? '') . ", " . ($brrow['brcity'] ?? '') .
        "\nGSTIN: " . ($brrow['tin'] ?? '') .
        "\nPHONE : 080-45313910\nEMAIL : INFO@AUTOSPEC.IN"
    );
    
    $leftTextEndY = $pdf->GetY();
    
    /* Insert Logo */
    $logoHeight = 18;
    $pdf->Image('../images/psn_logo_400.png', $leftMargin + 2, $leftTextEndY + 2, 30);
    
    /* BANK DETAILS — placed under logo */
    $pdf->SetXY($leftMargin, $leftTextEndY + $logoHeight);
    $pdf->SetFont('Arial', '', 7);
    $pdf->MultiCell(
        $leftBlockW,
        4,
        "Verified by:--\n\nBank Details: PSN AUTOMOTIVE MARKETING PVT. LTD\n" .
        "BRANCH : BANK OF BARODA, STJOHNS MEDICAL COLLEGE, BANGALORE BRANCH\n" .
        "A/C NO. 05210200001133\n" .
        "IFSC CODE. BARB0STJOHN"
    );
    
    $leftFinalY = $pdf->GetY();
    
    /**************************************
     * RIGHT SIDE ACCOUNTS BOX
     **************************************/
    $pdf->SetXY( 115, $baseY);
    
    $pdf->SetFont('Arial', 'B', 7);
    $pdf->Cell($rightBlockW, 6, 'ACCOUNTS', 1, 1, 'C');
    
    $pdf->SetXY( 115, $baseY+6);
    
    $pdf->SetFont('Arial', '', 7);
    $pdf->Cell($rightBlockW - 40, 6, 'PARTS TOTAL', 1, 0);
    $pdf->Cell(40, 6, putcoma($partstotal), 1, 1, 'R');
    
    $pdf->SetXY( 115, $baseY+12);
    
    $pdf->Cell($rightBlockW - 40, 6, 'DISCOUNT', 1, 0);
    $pdf->Cell(40, 6, putcoma($total_disc), 1, 1, 'R');
    
    $pdf->SetXY( 115, $baseY+18);
    
    $pdf->Cell($rightBlockW - 40, 6, 'CASH DISCOUNT', 1, 0);
    $pdf->Cell(40, 6, putcoma($totcshdis), 1, 1, 'R');
    
    $pdf->SetXY( 115, $baseY+24);
    
    if ($row['vatorcst'] == 'INTRASTATE') {
        $pdf->Cell($rightBlockW - 40, 6, 'CGST TOTAL', 1, 0);
        $pdf->Cell(40, 6, putcoma($cgst_tot), 1, 1, 'R');
        
        $pdf->SetXY( 115, $baseY+30);
    
        $pdf->Cell($rightBlockW - 40, 6, 'SGST TOTAL', 1, 0);
        $pdf->Cell(40, 6, putcoma($sgst_tot), 1, 1, 'R');
    } else {
        $pdf->Cell($rightBlockW - 40, 6, 'IGST TOTAL', 1, 0);
        $pdf->Cell(40, 6, putcoma($igst_tot), 1, 1, 'R');
    }
    
    $dif1=round($jtot);
    $dif=round(($dif1-$jtot),2);
    
    $pdf->SetXY( 115, $baseY+36);
    
    $pdf->Cell($rightBlockW - 40, 6, 'ROUND OFF', 1, 0);
    $pdf->Cell(40, 6, putcoma($dif), 1, 1, 'R');
    
    $pdf->SetXY( 115, $baseY+42);
    
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell($rightBlockW - 40, 8, 'NET AMOUNT', 1, 0);
    $pdf->Cell(40, 8, putcoma(round($jtot)), 1, 1, 'R');
    
    $rightFinalY = $pdf->GetY();
    
    /**************************************
     * RUPEES IN WORDS
     **************************************/
    // $pdf->SetXY($leftMargin, max($leftFinalY, $rightFinalY) + 4);
    
    $pdf->SetXY( 115, $baseY+50);
    $pdf->SetFont('Arial', '', 6);
    $pdf->MultiCell($leftBlockW, 6, 'RUPEES ' . strtoupper(numToWords(round($jtot))) . ' ONLY');
    
    /**************************************
     * RECEIVER SIGNATURE
     **************************************/
    $pdf->SetXY( 83, $baseY+60);
    // $pdf->SetXY($leftMargin + $leftBlockW + $gap, max($leftFinalY, $rightFinalY) + 4);
    $pdf->Cell($rightBlockW, 6, 'RECEIVER SIGNATURE', 0, 1, 'C');
    
    // Page number bottom-right
    // $pdf->SetY(-18);
    // $pdf->SetFont('Arial', '', 8);
    // $pdf->Cell(0, 6, 'Page: ' . ($p + 1) . '/' . ($pg_no + 1), 0, 0, 'R');
}

/* Stream PDF inline to browser */
$filename = "invoice_{$invno}.pdf";
// $pdf->Output('I', $filename);

$savePath = $_SERVER["DOCUMENT_ROOT"] . '/force2526/paypdf/custfolder/' . $filename;
$pdf->Output('F', $savePath);

/* cleanup QR temp file */
if (!empty($qr_temp) && file_exists($qr_temp)) {
    @unlink($qr_temp);
}
exit;
?>