<?php
$br_code = $_GET['brcode'];
$invno  = $_GET['invno'];



include("opendb.php");
// include("test.php"); // for word(), putcoma() etc
// echo $br_code;
// FPDF
require_once("paypdf/fpdf.php");

// Request params
// $invno   = $_REQUEST['invno'] ?? '';
// $mnfr    = $_REQUEST['mnfr'] ?? '';
// $foc     = $_REQUEST['foc'] ?? '';
// $invtype = $_REQUEST['invtype'] ?? '';

// -------------------------
// Fetch header/main records
// -------------------------


if ($foc == 'foc') {
    $re = mysqli_query($db, "SELECT * FROM spareinvoicefoc WHERE invno='$invno' AND invtype='$invtype' AND brcode='$br_code'");
} else {
    $re = mysqli_query($db, "SELECT * FROM spareinvoice WHERE invno='$invno' AND brcode='$br_code'");
}

// echo "SELECT * FROM spareinvoice WHERE invno='$invno' AND brcode='$br_code'";

if (!$re || mysqli_num_rows($re) <= 0) {
    die("Invoice No does not exist");
}

function word($x)
{
$x=str_replace(".","-",$x);
$num=explode('-',$x); 

if($num[1]>0)
{
 $m="Rupees ".ConvertToWords($num[0])." and ".ConvertToWords($num[1])." paise";
 return $m;
}
else
{ $m= "Rupees ".ConvertToWords($num[0]);
 return $m;
}

}

function putComa($num) {
    if(strlen($num)==0)
    return;
    
    if(strlen(strstr($num,"."))<=0) { 
        $v=$num.".00";
    }
    else $v=$num;
    $a='';
    $a=explode(".",$v);
    if(strlen($a[1])==1)
    $v.="0";
    //print $v;
    if(strlen($a[0])>8) {
        $v=substr($v,0,2).",".substr($v,2,2).",".substr($v,4,2).",".substr($v,6);
    }
    else if(strlen($a[0])>7) {
        $v=substr($v,0,1).",".substr($v,1,2).",".substr($v,3,2).",".substr($v,5);
    }
    else if(strlen($a[0])>6) {
        $v=substr($v,0,2).",".substr($v,2,2).",".substr($v,4);
    }
    else if(strlen($a[0])>5) {
        $v=substr($v,0,1).",".substr($v,1,2).",".substr($v,3);
    }
    else if(strlen($a[0])>4) {
        $v=substr($v,0,2).",".substr($v,2,6);
    }
    else if(strlen($a[0])>3) {
        $v=substr($v,0,1).",".substr($v,1);
    }
    return $v;
}

function ConvertToWords($n, $followup='')  
 {  
     if($n==0)  
     {  
         if($followup=='no')  
         {  
             return "";  
             exit();  
         }  
        else  
         {  
             return "zero";  
             exit();  
         }  
     }  
     switch($n)  
    {  
         case 1: return "one"; break;  
         case 2: return "two"; break;  
         case 3: return "three"; break;  
         case 4: return "four"; break;  
         case 5: return "five"; break;  
         case 6: return "six"; break;  
         case 7: return "seven"; break;  
         case 8: return "eight"; break;  
         case 9: return "nine"; break;  
         case 10: return "ten"; break;  
         case 11: return "eleven"; break;  
         case 12: return "twelve"; break;  
         case 13: return "thirteen"; break;  
         case 14: return "fourteen"; break;  
         case 15: return "fifteen"; break;  
         case 16: return "sixteen"; break;  
         case 17: return "seventeen"; break;  
         case 18: return "eighteen"; break;  
         case 19: return "nineteen"; break;  
        case 20: return "twenty"; break;  
         case 30: return "thirty"; break;  
         case 40: return "forty"; break;  
         case 50: return "fifty"; break;  
         case 60: return "sixty"; break;  
         case 70: return "seventy"; break;  
         case 80: return "eighty"; break;  
         case 90: return "ninety"; break;  
         case 100: return "one hundred"; break;  
         case 1000: return "one thousand"; break;  
         case 100000: return "one lakh"; break;  
         default:  
         {  
             if($n<100)  
             {  
                 return ConvertToWords(floor($n/10)*10, 'no')."-".ConvertToWords($n%10, 'no'); break;  
             }  
             elseif($n<1000)  
             {  
                 return ConvertToWords(floor($n/100), 'no')." hundred ".ConvertToWords($n%100, 'no'); break;  
             }  
             elseif($n<100000)  
             {  
                 return ConvertToWords(floor($n/1000), 'no')." thousand ".ConvertToWords($n%1000, 'no'); break;  
             }  
             elseif($n<10000000)  
             {  
                 return ConvertToWords(floor($n/100000), 'no')." lakh ".ConvertToWords($n%100000, 'no'); break;  
             }  
             else  
             {  
                 return "Something else"; break;  
             }  
         }  
     }  
 } 

$jcrow = mysqli_fetch_assoc($re);
$maddr = $jcrow['addr'];

// Financial year check
$query1  = mysqli_query($db, "SELECT acfrom, acto FROM acperiod");
$per_row = mysqli_fetch_array($query1);

if ($jcrow['entrydate'] > $per_row[1] || $jcrow['entrydate'] < $per_row[0]) {
    die("Invoice not in this financial year !!!!!");
}

// Branch
$brres = mysqli_query($db, "SELECT * FROM branch WHERE brcode='$br_code'");
$brrow = mysqli_fetch_assoc($brres);

// Customer
$cusres = mysqli_query($db, "SELECT * FROM customer WHERE acname='{$jcrow['customer']}' AND brcode='$br_code'");
$cusrow = mysqli_fetch_assoc($cusres);

// IRN / QR
$qrqry = mysqli_query($db, "SELECT * FROM tbl_einvoice WHERE invno='{$jcrow['invno']}' AND brcode='$br_code'");
$qrrow = mysqli_fetch_assoc($qrqry);
$signedqr = $qrrow['SignedQRCode'] ?? '';
$irn      = $qrrow['irnno'] ?? '';

// ----------------------------------------
// Build line items (same logic as HTML)
// ----------------------------------------
$itemsRes = mysqli_query($db, "SELECT * FROM " . ($foc == 'foc' ? "spareinvoicefoc" : "spareinvoice") . " WHERE invno='$invno' AND brcode='$br_code'");
if (!$itemsRes) {
    die("Item query error: " . mysqli_error($db));
}

$rows = [];
$partstotal = 0;
$total_disc = 0;
$totcshdis  = 0;
$pdisctot   = 0;
$qty_tot    = 0;
$rate_tot   = 0;
$sgst_tot   = 0;
$cgst_tot   = 0;
$igst_tot   = 0;
$jtot       = 0;

$i = 1;

while ($r = mysqli_fetch_assoc($itemsRes)) {

    $code   = $r['partcode'];
    $item   = $r['partname'];
    $qty    = $r['qty'];
    $rate   = $r['price'];

    $qtyprcamt   = $qty * $rate;
    $partstotal += $qtyprcamt;

    $discamt     = $qtyprcamt * $r['disc'] / 100;
    $total_disc += $discamt;

    $afterdis    = $qtyprcamt - $discamt;
    $cashdisamt  = $afterdis * ($r['cshdisc'] / 100);
    $totcshdis  += $cashdisamt;

    $pdisctot   += $r['disc'];
    $qty_tot    += $qty;
    $rate_tot   += $rate;

    // MRP
    if ($br_code == 'YES001') {
        $sprqry = "SELECT mrp FROM spareprmast_retail WHERE partcode='$code' ORDER BY effectfrom DESC LIMIT 1";
    } else {
        $sprqry = "SELECT mrp FROM spareprmast WHERE partcode='$code' ORDER BY effectfrom DESC LIMIT 1";
    }
    $sprres = mysqli_query($db, $sprqry);
    $sprrow = mysqli_fetch_row($sprres);
    $mrp    = $sprrow[0] ?? 0;

    // HSN from location
    if ($br_code == 'YES001') {
        $qry = "SELECT location FROM partmaster_retail WHERE partcode='{$r['partcode']}'";
    } else {
        $qry = "SELECT location FROM partmaster WHERE partcode='{$r['partcode']}'";
    }
    $rsqr = mysqli_query($db, $qry);
    $rsrw = mysqli_fetch_array($rsqr);
    if (strlen($rsrw[0]) == 0) {
        $hsncd = 0;
    } else {
        $hsncd = $rsrw[0];
    }

    $taxable = $r['aprice'];
    $cgstp   = 0;
    $sgstp   = 0;
    $igstp   = 0;
    $cgstamt = 0;
    $sgstamt = 0;
    $igstamt = 0;

    if ($jcrow['vatorcst'] == 'INTRASTATE') {
        $cgstp   = $r['cgstp'];
        $sgstp   = $r['sgstp'];
        $cgstamt = $r['cgstamt'];
        $sgstamt = $r['sgstamt'];
        $sgst_tot += $sgstamt;
        $cgst_tot += $cgstamt;
    } elseif ($jcrow['vatorcst'] == 'INTERSTATE') {
        $igstp   = $r['igstp'];
        $igstamt = $r['igstamt'];
        $igst_tot += $igstamt;
    }

    $ptot = $r['tot'];
    $jtot += $ptot;
    
    $qr_temp = '';
    if (!empty($signedqr)) {
        $qr_url = "https://qrcode.tec-it.com/API/QRCode?size=small&dpi=150&data=" . urlencode($signedqr);
        $qr_temp = sys_get_temp_dir() . '/qr_' . md5($signedqr) . '.png';
        $ch = curl_init($qr_url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $qr_data = curl_exec($ch);
        $http_status = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
        curl_close($ch);
        if ($qr_data !== false && $http_status >= 200 && $http_status < 300) {
            file_put_contents($qr_temp, $qr_data);
        } else {
            $qr_temp = '';
        }
    }

    $rows[$i] = [
        'slno'        => $i,
        'partcode'    => $code,
        'partname'    => $item,
        'qty'         => $qty,
        'rate'        => $rate,
        'qtyprcamt'   => $qtyprcamt,
        'disc'        => $r['disc'],
        'discamt'     => $discamt,
        'cashdisamt'  => $cashdisamt,
        'mrp'         => $mrp,
        'hsn'         => $hsncd,
        'taxable'     => $taxable,
        'cgstp'       => $cgstp,
        'sgstp'       => $sgstp,
        'cgstamt'     => $cgstamt,
        'sgstamt'     => $sgstamt,
        'igstp'       => $igstp,
        'igstamt'     => $igstamt,
        'ptot'        => $ptot
    ];

    $i++;
}

$count = count($rows);
$limit = 22;
$totalPages = $count > 0 ? ceil($count / $limit) : 1;

// Pay type
$ptype = $jcrow['paytype'];

// ----------------------------------------
// Helper: build address/state/ref exactly
// ----------------------------------------
$pre_by1 = explode("|", $jcrow['ref']);
$mref1   = $pre_by1[0] ?? '';
$pre_by  = $pre_by1[1] ?? '';

$mstate = $cusrow['state1'];
if ($mstate == '') {
    $mstate = $jcrow['invtype'];
}

$maddr = $jcrow['addr1'];
if (strlen($cusrow['pin1']) > 0) {
    $maddr .= " PIN:" . $cusrow['pin1'];
}
if (strlen($cusrow['phone1']) > 0) {
    $maddr .= " Phone:" . $cusrow['phone1'];
}

// Invoice date (entrydate -> dd-mm-yyyy)
$entrydate = $jcrow['entrydate'];
$fromdt1   = implode('-', array_reverse(explode('-', $entrydate)));

// ----------------------------------------
// FPDF Class (we'll manage header/footer manually)
// ----------------------------------------
class SpareInvoicePDF extends FPDF
{
    public $br_code;
    public $totalPages;

    function Header()
    {
        // We'll draw everything manually per page from outside,
        // so keep FPDF header empty to avoid double-printing.
    }

    function Footer()
    {
        // We'll print page numbers manually outside.
    }
    
    function Row($data, $widths, $aligns = [])
    {
        $nb = 0;
        for ($i = 0; $i < count($data); $i++) {
            $nb = max($nb, $this->NbLines($widths[$i], $data[$i]));
        }
        $h = 5 * $nb; // each line = 5mm height
    
        // Page break if needed
        if ($this->GetY() + $h > $this->PageBreakTrigger) {
            $this->AddPage();
        }
    
        // Draw cells
        for ($i = 0; $i < count($data); $i++) {
            $w = $widths[$i];
            $a = isset($aligns[$i]) ? $aligns[$i] : 'L';
    
            $x = $this->GetX();
            $y = $this->GetY();
    
            // Draw border
            $this->Rect($x, $y, $w, $h);
    
            // Print text
            $this->MultiCell($w, 5, $data[$i], 0, $a);
    
            // Set X for next cell
            $this->SetXY($x + $w, $y);
        }
    
        // Move cursor to next row
        $this->Ln($h);
    }
    
    // Count lines required
    function NbLines($w, $txt)
    {
        $cw = &$this->CurrentFont['cw'];
        if ($w == 0)
            $w = $this->w - $this->rMargin - $this->x;
        $wmax = ($w - 2) * 1000 / $this->FontSize;
        $s = str_replace("\r", '', (string)$txt);
        $nb = strlen($s);
        if ($nb > 0 && $s[$nb - 1] == "\n")
            $nb--;
        $sep = -1;
        $i = 0;
        $j = 0;
        $l = 0;
        $nl = 1;
        while ($i < $nb) {
            $c = $s[$i];
            if ($c == "\n") {
                $i++;
                $sep = -1;
                $j = $i;
                $l = 0;
                $nl++;
                continue;
            }
            if ($c == ' ')
                $sep = $i;
            $l += $cw[$c];
            if ($l > $wmax) {
                if ($sep == -1) {
                    if ($i == $j)
                        $i++;
                } else {
                    $i = $sep + 1;
                }
                $sep = -1;
                $j = $i;
                $l = 0;
                $nl++;
            } else {
                $i++;
            }
        }
        return $nl;
    }
}

$pdf = new SpareInvoicePDF('P', 'mm', 'A4');
$pdf->SetMargins(10, 10, 10);
$pdf->SetAutoPageBreak(false);
$pdf->brcode     = $br_code;
$pdf->totalPages = $totalPages;

// Column widths (portrait, squeezed)
$intraw = [7, 14, 33, 10, 8, 11, 11, 8, 11, 11, 15, 8, 11, 8, 11, 13]; // 16 cols, sum ~190
// SlNo, PartCode, PartName, HSN, Qty, Rate, MRP, Disc%, DiscAmt, CashDisc,
// Taxable, CGST%, CGSTAmt, SGST%, SGSTAmt, Total

$interw = [7, 14, 38, 10, 8, 11, 11, 11, 15, 10, 15, 15]; // 12 cols, also ~190

// ----------------------------------------
// Main page loop
// ----------------------------------------
for ($p = 1; $p <= $totalPages; $p++) {

    $pdf->AddPage();
    $pdf->SetFont('Arial', '', 9);

    // ------------------ Top Logo / IRN / QR ------------------
    $y = 10;

    // Autospec logo for certain branches
    if (in_array($br_code, ['BLRACC', 'HUBACC', 'HYDACC']) && file_exists('images/autospec_logo.jpeg')) {
        $pdf->Image('images/autospec_logo.jpeg', 80, $y - 2, 50);
        $y += 12;
    }

    // IRN text
    $pdf->SetXY(10, $y);
    $pdf->SetFont('Arial', '', 9);
    if ($irn != '') {
        $pdf->Cell(90, 5, 'IRN: ' . $irn, 0, 0, 'L');
    }

    // QR code (safe download)
    if (!empty($qr_temp) && file_exists($qr_temp)) {
        $pdf->Image($qr_temp, $pdf->GetPageWidth() - $rightMargin - 42, 8, 32, 32);
    }

    $y += 10;
    $pdf->SetY($y + 10);

    // ------------------ Invoice Title & Number ------------------
    // $pdf->SetY(42);
    // $pdf->SetFont('Arial', 'B', 12);
    // $pdf->SetX($leftMargin);
    
    // Left cell: INVNO
    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(66, 8, "INVNO: " . $jcrow['invno'], 1, 0, 'L');
    
    // Middle cell: FORM GST INV - 1
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->Cell(
        $pdf->GetPageWidth() - $leftMargin - $rightMargin - 40 - 96, // middle width
        8,
        "FORM GST INV - 1",
        1,
        0,
        'C'
    );
    
    // Right cell: INVDT
    $pdf->SetFont('Arial', '', 9);
    $invdt = date('d-m-Y', strtotime($fromdt1));
    $pdf->Cell(50, 8, "INVDT: $invdt", 1, 1, 'R');
    
    // $pdf->SetFont('Arial', '', 10);
    // $pdf->Cell(60, 7, 'INVNO: ' . $jcrow['invno'], 1, 0, 'L');

    // $pdf->SetFont('Arial', 'B', 12);
    // $pdf->Cell(70, 7, 'FORM GST INV - 1', 0, 0, 'C');

    // $pdf->SetFont('Arial', '', 10);
    // $pdf->Cell(50, 7, 'INVDT: ' . $fromdt1, 1, 1, 'R');

    // Invoice type: Cash / Credit
    $pdf->SetX(70);
    $pdf->SetFont('Arial', 'B', 11);
    if ($ptype == 'Cash') {
        $pdf->Cell(70, 6, 'Cash Invoice', 0, 1, 'C');
    } else {
        $pdf->Cell(70, 6, 'Credit Invoice', 0, 1, 'C');
    }

    $pdf->Ln(2);

    // ------------------ Receiver / Consignee tables ------------------
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Cell(95, 6, 'Details of Receiver (Billed to)', 1, 0, 'L');
    $pdf->Cell(95, 6, 'Details of Consignee (Shipped to)', 1, 1, 'L');

    $pdf->SetFont('Arial', '', 8);

    // Row 1: Name
    $pdf->Cell(20, 5, 'Name', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $jcrow['customer'], 1);

    $pdf->Cell(20, 5, 'Name', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $jcrow['customer'], 1);
    $pdf->Ln(5);

    // Address
    $pdf->Cell(20, 5, 'Address', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $maddr, 1);

    $pdf->Cell(20, 5, 'Address', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $maddr, 1);
    $pdf->Ln(5);

    // State
    $pdf->Cell(20, 5, 'State', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $mstate, 1);

    $pdf->Cell(20, 5, 'State', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $mstate, 1);
    $pdf->Ln(5);

    // GSTIN
    $pdf->Cell(20, 5, 'GSTIN', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $cusrow['gst'], 1);

    $pdf->Cell(20, 5, 'GSTIN', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $cusrow['gst'], 1);
    $pdf->Ln(5);

    // PAN
    $pdf->Cell(20, 5, 'PAN', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $cusrow['cst'], 1);

    $pdf->Cell(20, 5, 'PAN', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $cusrow['cst'], 1);
    $pdf->Ln(5);

    // Ref
    $pdf->Cell(20, 5, 'Ref', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $mref1 . $jcrow['msno'], 1);

    $pdf->Cell(20, 5, 'Ref', 1);
    $pdf->Cell(5, 5, ':', 1);
    $pdf->Cell(70, 5, $mref1 . $jcrow['msno'], 1);
    $pdf->Ln(7);

    // ------------------ Items Table Header ------------------
    $pdf->SetFont('Arial', 'B', 7);

    if ($jcrow['vatorcst'] == 'INTRASTATE') {
        $headers = [
            'SlNo', 'PartCode', 'Part Name', 'HSN Code', 'Qty',
            'Rate', 'MRP', 'Disc%', 'Disc Amt', 'Cash Disc',
            'Taxable', 'CGST%', 'CGST Amt', 'SGST%', 'SGST Amt', 'Total Amt'
        ];
        $widths = $intraw;

    } else {
        $headers = [
            'SlNo', 'PartCode', 'Part Name', 'HSN Code', 'Qty',
            'Rate', 'MRP', 'Disc%', 'Disc Amt', 'Cash Disc',
            'Taxable', 'IGST%', 'IGST Amt', 'Total Amt'
        ];
        // Adjust widths for 14 columns (reuse/interpolate from interw)
        $widths = [7, 14, 38, 10, 8, 11, 11, 8, 11, 11, 15, 10, 15, 15];
    }
    
    $headers2 = [];
    foreach ($headers as $h) {
        $words = explode(' ', $h);
    
        if (count($words) == 2) {
            // Example: "Part Name" → "Part\nName"
            $headers2[] = $words[0] . "\n" . $words[1];
        } else {
            $headers2[] = $h;
        }
    }
    
    $pdf->SetFont('Arial', 'B', 7);
    
    // Header row height (two lines)
    $headerHeight = 8;   // You may adjust to match table look
    $lineHeight   = 4;   // Height of one wrapped line
    
    // Print header row with MultiCell()
    for ($i = 0; $i < count($headers2); $i++) {
    
        $x = $pdf->GetX();
        $y = $pdf->GetY();
        $w = $widths[$i];
    
        // Draw the outer cell border
        $pdf->Rect($x, $y, $w, $headerHeight);
    
        // Print header inside cell using MultiCell
        $pdf->MultiCell($w, $lineHeight, $headers2[$i], 0, 'C');
    
        // Move cursor to the right side of the cell (important)
        $pdf->SetXY($x + $w, $y);
    }
    
    $pdf->Ln($headerHeight);

    // ------------------ Items Slice for this Page ------------------
    $pdf->SetFont('Arial', '', 7);
    $start = ($p - 1) * $limit + 1;
    $end   = min($p * $limit, $count);

    for ($k = $start; $k <= $end; $k++) {
        if (!isset($rows[$k])) {
            break;
        }
        $r = $rows[$k];

        if ($jcrow['vatorcst'] == 'INTRASTATE') {
            $data = [
                $r['slno'],
                $r['partcode'],
                $r['partname'],
                $r['hsn'],
                $r['qty'],
                number_format($r['rate'], 2),
                number_format($r['mrp'], 2),
                $r['disc'] == 0 ? '' : number_format($r['disc'], 2),
                round($r['discamt'], 2) == 0 ? '' : number_format($r['discamt'], 2),
                round($r['cashdisamt'], 2) == 0 ? '' : number_format($r['cashdisamt'], 2),
                number_format($r['taxable'], 2),
                $r['cgstp'],
                number_format($r['cgstamt'], 2),
                $r['sgstp'],
                number_format($r['sgstamt'], 2),
                number_format($r['ptot'], 2)
            ];
        } else {
            $data = [
                $r['slno'],
                $r['partcode'],
                $r['partname'],
                $r['hsn'],
                $r['qty'],
                number_format($r['rate'], 2),
                number_format($r['mrp'], 2),
                $r['disc'] == 0 ? '' : number_format($r['disc'], 2),
                round($r['discamt'], 2) == 0 ? '' : number_format($r['discamt'], 2),
                round($r['cashdisamt'], 2) == 0 ? '' : number_format($r['cashdisamt'], 2),
                number_format($r['taxable'], 2),
                $r['igstp'],
                number_format($r['igstamt'], 2),
                number_format($r['ptot'], 2)
            ];
        }

        $pdf->SetFont('Arial', '', 7);

        // define alignment for each column
        $aligns = [];
        foreach ($data as $idx => $d) {
            $aligns[$idx] = is_numeric(str_replace([',','.'], '', $d)) ? 'R' : 'L';
        }
        
        // Use new Row() function
        $pdf->Row($data, $widths, $aligns);
    }

    // Total row for qty & rate (like HTML)
    $pdf->SetFont('Arial', 'B', 7);
    if ($jcrow['vatorcst'] == 'INTRASTATE') {
        // <th><th><th colspan=2><th></th><th>$qty_tot<th>$rate_tot....
        $pdf->Cell($widths[0], 5, '', 1);
        $pdf->Cell($widths[1], 5, '', 1);
        $pdf->Cell($widths[2], 5, '', 1);
        $pdf->Cell($widths[3], 5, '', 1);
        $pdf->Cell($widths[4], 5, $qty_tot, 1, 0, 'R');
        $pdf->Cell($widths[5], 5, $rate_tot, 1, 0, 'R');
        // rest empty
        for ($ii = 6; $ii < count($widths); $ii++) {
            $pdf->Cell($widths[$ii], 5, '', 1);
        }
    } else {
        $pdf->Cell($widths[0], 5, '', 1);
        $pdf->Cell($widths[1], 5, '', 1);
        $pdf->Cell($widths[2], 5, '', 1);
        $pdf->Cell($widths[3], 5, '', 1);
        $pdf->Cell($widths[4], 5, $qty_tot, 1, 0, 'R');
        $pdf->Cell($widths[5], 5, $rate_tot, 1, 0, 'R');
        for ($ii = 6; $ii < count($widths); $ii++) {
            $pdf->Cell($widths[$ii], 5, '', 1);
        }
    }
    $pdf->Ln(7);

    // ------------------ Totals + Signatures (only last page shows numbers) ------------------
    $pdf->SetFont('Arial', '', 8);

    $pdf->Cell(60, 5, 'DSR : ' . $jcrow['engineer'], 0, 0, 'L');
    $pdf->Cell(60, 5, 'Prepared by : ' . $pre_by, 0, 0, 'L');

    // Right side account box
    $xRight = 115;
    $yRight = $pdf->GetY() - 2;

    $pdf->SetXY($xRight, $yRight);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(85, 5, 'Accounts', 1, 1, 'L');

    $pdf->SetFont('Arial', '', 8);
    $pdf->SetX($xRight);
    $pdf->Cell(55, 5, 'Parts Total', 1, 0, 'R');
    $pdf->Cell(30, 5, ($p == $totalPages ? putcoma($partstotal) : ''), 1, 1, 'R');

    $pdf->SetX($xRight);
    $pdf->Cell(55, 5, 'DISCOUNT', 1, 0, 'R');
    $pdf->Cell(30, 5, ($p == $totalPages ? putcoma($total_disc) : ''), 1, 1, 'R');

    $pdf->SetX($xRight);
    $pdf->Cell(55, 5, 'CASH DISCOUNT', 1, 0, 'R');
    $pdf->Cell(30, 5, ($p == $totalPages ? putcoma($totcshdis) : ''), 1, 1, 'R');

    $pdf->SetX($xRight);
    $pdf->Cell(55, 5, 'CGST Total', 1, 0, 'R');
    $pdf->Cell(30, 5, ($p == $totalPages ? $cgst_tot : ''), 1, 1, 'R');

    $pdf->SetX($xRight);
    $pdf->Cell(55, 5, 'SGST Total', 1, 0, 'R');
    $pdf->Cell(30, 5, ($p == $totalPages ? $sgst_tot : ''), 1, 1, 'R');

    $pdf->SetX($xRight);
    $pdf->Cell(55, 5, 'IGST Total', 1, 0, 'R');
    $pdf->Cell(30, 5, ($p == $totalPages ? $igst_tot : ''), 1, 1, 'R');

    $dif1 = round($jtot);
    $dif  = round(($dif1 - $jtot), 2);

    $pdf->SetX($xRight);
    $pdf->Cell(55, 5, 'Round Off', 1, 0, 'R');
    $pdf->Cell(30, 5, ($p == $totalPages ? putcoma($dif) : ''), 1, 1, 'R');

    $pdf->SetX($xRight);
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Cell(55, 6, 'Net Amount', 1, 0, 'R');
    $pdf->Cell(30, 6, ($p == $totalPages ? putcoma(round($jtot)) : ''), 1, 1, 'R');

    // Amount in words + Receiver Signature (only once is enough, but mirroring HTML per page)
    if ($p == $totalPages) {
        $pdf->Ln(3);
        $pdf->SetX($xRight);
        $pdf->SetFont('Arial', '', 8);
        $pdf->Cell(0, 5, 'Amount in words: ' . word(round($jtot)), 0, 1, 'L');
        $pdf->Ln(10);
        $pdf->SetX($xRight);
        $pdf->Cell(0, 5, 'RECEIVER SIGNATURE', 0, 1, 'L');
    }

    // ------------------ Bottom PSN block + Bank details ------------------
   // Start footer zone
    $pdf->SetY(230);
    
    // LEFT COLUMN WIDTH
    $leftW = 120;
    
    // -------------------------
    // LEFT COLUMN (Company info)
    // -------------------------
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->MultiCell($leftW, 5, "PSN AUTOMOTIVE MARKETING PRIVATE LIMITED", 0, 'L');
    
    $pdf->SetFont('Arial', '', 8);
    
    // Build wrapped left text
    $footerText  = $brrow['braddr'] . ', ' . $brrow['brcity'] . "\n";
    $footerText .= "GSTIN: " . $brrow['tin'] . "\n";
    $footerText .= "Phone: 080-45313910\n";
    $footerText .= "Email: info@autospec.in";
    
    $pdf->MultiCell($leftW, 4, $footerText, 0, 'L');
    
    // ➜ After MultiCell, Y has advanced automatically
    // Save current Y position after left column
    $afterLeftY = $pdf->GetY();
    
    
    // -------------------------
    // RIGHT COLUMN (Bank + Verified)
    // -------------------------
    $pdf->SetXY(140, 230); // Right column start (120 + 10 padding)
    
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(60, 5, "Verified by: --", 0, 1, 'L');
    
    $pdf->SetX(140);
    $pdf->Cell(60, 5, "Bank Details:", 0, 1, 'L');
    
    $pdf->SetX(140);
    $pdf->MultiCell(60, 4,
        "PSN Automotive Marketing Pvt. Ltd\n" .
        "Bank of Baroda, StJohns Medical College\n" .
        "A/c No. 05210200001133\n" .
        "IFSC: BARB0STJOHN",
        0, 'L'
    );
    
    // Save Y after right column
    $afterRightY = $pdf->GetY();
    
    
    // -------------------------
    // Align logo AFTER both columns finish
    // -------------------------
    $finalY = max($afterLeftY, $afterRightY);
    
    $pdf->SetY($finalY + 2); // small padding
    
    if (file_exists('images/psn_logo_400.png')) {
        $pdf->Image('images/psn_logo_400.png', 10, $pdf->GetY(), 30);
    }
    
    // $pdf->SetXY(60, 245);
    // $pdf->SetFont('Arial', '', 8);
    // $pdf->Cell(0, 4, 'Verified by: --', 0, 1, 'L'); 

    // $pdf->SetXY(60, 250);
    // $pdf->Cell(0, 4, 'Bank Details: PSN Automotive Marketing Pvt. Ltd', 0, 1, 'L');
    // $pdf->SetX(60);
    // $pdf->Cell(0, 4, 'BRANCH : Bank of Baroda, StJohns Medical College, Bangalore branch', 0, 1, 'L');
    // $pdf->SetX(60);
    // $pdf->Cell(0, 4, 'A/c No. 05210200001133', 0, 1, 'L');
    // $pdf->SetX(60);
    // $pdf->Cell(0, 4, 'IFSC Code. BARB0STJOHN', 0, 1, 'L');

    // Page number
    $pdf->SetY(-12);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(0, 6, 'Page: ' . $p . '/' . $totalPages, 0, 0, 'R');
}

// Output
// $pdf->Output('I', 'spare_invoice_' . $invno . '.pdf');

$pdf->Output('D', 'spare_invoice_' . $invno . '.pdf', true);
