<?php
require("../paypdf/fpdf.php");
include('../opendb.php');

$brcode = $_GET['brcode'];
$invno  = $_GET['invno'];

// -------------------------
// Fetch all data (same as your current logic)
// -------------------------
$res = mysqli_query($db, "SELECT * FROM salesreturn WHERE retno='$invno' AND brcode='$brcode'");
if (mysqli_num_rows($res) <= 0) {
    die("Invoice does not exist");
}
$row = mysqli_fetch_assoc($res);

$br = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM branch WHERE brcode='$brcode'"));
$cus = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM customer WHERE acname='{$row['customer']}' AND brcode='$brcode'"));
$purch = mysqli_fetch_assoc(mysqli_query($db, "SELECT invno, invdate, entrydate FROM spareinvoice WHERE brcode='$brcode' AND invno='{$row['invno']}'"));

$qr = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM tbl_einvoice WHERE invno='$invno' AND brcode='$brcode'"));
$signedqr = $qr['SignedQRCode'];
$irn      = $qr['irnno']; 


class PDF extends FPDF {

    // MultiCell line counter
    function NbLines($w, $txt) {
        $cw = $this->CurrentFont['cw'];
        if($w == 0)
            $w = $this->w - $this->rMargin - $this->x;

        $wmax = ($w - 2*$this->cMargin) * 1000 / $this->FontSize;
        $s = str_replace("\r", '', $txt);
        $nb = strlen($s);

        if ($nb > 0 && $s[$nb-1] == "\n")
            $nb--;

        $sep = -1;
        $i = 0;
        $j = 0;
        $l = 0;
        $nl = 1;

        while ($i < $nb) {
            $c = $s[$i];
            if ($c == "\n") {
                $i++;
                $sep = -1;
                $j = $i;
                $l = 0;
                $nl++;
                continue;
            }

            if ($c == ' ')
                $sep = $i;

            $l += $cw[$c];

            if ($l > $wmax) {
                if ($sep == -1) {
                    if ($i == $j)
                        $i++;
                } else
                    $i = $sep + 1;

                $sep = -1;
                $j = $i;
                $l = 0;
                $nl++;
            } else {
                $i++;
            }
        }
        return $nl;
    }
}

// -------------------------
// Create PDF
// -------------------------
$pdf = new PDF('P', 'mm', 'A4');
$pdf->AddPage();
$pdf->SetFont('Arial','',10);

// ---------------------
// QR Code First (Before header)
// ---------------------
if ($signedqr != '') {

    $qrTemp = "qr_$invno.png";
    $qrUrl  = "https://chart.googleapis.com/chart?chs=200x200&cht=qr&chl=" . urlencode($signedqr);
    $qrImg  = @file_get_contents($qrUrl);

    if ($qrImg !== false) {
        file_put_contents($qrTemp, $qrImg);
        $pdf->Image($qrTemp, 165, 10, 30, 30);
    }
}

// ---------------------
// HEADER
// ---------------------
$pdf->SetFont('Arial','B',14);
$pdf->Cell(0, 7, 'PSN AUTOMOTIVE MARKETING PVT LTD', 0, 1, 'C');

$pdf->SetFont('Arial','',10);
$pdf->Cell(0, 5, "GSTIN: {$br['tin']}", 0, 1, 'C');

$address = "{$br['braddr']}, {$br['brcity']} - Phone: {$br['brphone']}";
$pdf->MultiCell(0, 5, $address, 0, 'C');

$pdf->Ln(2);
$startY = $pdf->GetY();     // <-- IMPORTANT

// ---------------------
// INVOICE TITLE
// ---------------------
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0, 10, "Credit Note - RETNO: $invno", 0, 1, 'C');
$pdf->Ln(3);

// ---------------------
// RECEIVER + CONSIGNEE BLOCK
// ---------------------
$rowHeight = 7;

$pdf->SetFont('Arial','B',11);
$pdf->Cell(95, $rowHeight, "Details of Receiver (Billed To)", 1, 0);
$pdf->Cell(95, $rowHeight, "Details of Consignee (Shipped To)", 1, 1);

$pdf->SetFont('Arial','',8);

// function row2($pdf, $label, $val1, $val2, $rowHeight){
//     $pdf->Cell(30, $rowHeight, $label, 1);
//     $pdf->Cell(65, $rowHeight, $val1, 1);
//     $pdf->Cell(30, $rowHeight, $label, 1);
//     $pdf->Cell(65, $rowHeight, $val2, 1, 1);
// }

function row2($pdf, $label, $val1, $val2, $h){

    $wLabel  = 15;   // LEFT LABEL
    $wValue  = 80;   // LEFT VALUE
    $wLabel2 = 15;   // RIGHT LABEL
    $wValue2 = 80;   // RIGHT VALUE

    $pdf->Cell($wLabel, $h, $label, 1);
    $pdf->Cell($wValue, $h, $val1, 1);
    $pdf->Cell($wLabel2, $h, $label, 1);
    $pdf->Cell($wValue2, $h, $val2, 1, 1);
}

function NbLines($pdf, $w, $txt) {
    $cw = &$pdf->CurrentFont['cw'];
    if($w==0)
        $w = $pdf->w - $pdf->rMargin - $pdf->x;
    $wmax = ($w - 2*$pdf->cMargin) * 1000 / $pdf->FontSize;
    $s = str_replace("\r", '', $txt);
    $nb = strlen($s);
    if($nb>0 && $s[$nb-1]=="\n")
        $nb--;
    $sep = -1; $i = 0; $j = 0; $l = 0; $nl = 1;

    while($i < $nb){
        $c = $s[$i];
        if($c=="\n"){
            $i++;
            $sep = -1;
            $j   = $i;
            $l   = 0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep = $i;
        $l += $cw[$c];
        if($l > $wmax){
            if($sep == -1){
                if($i == $j)
                    $i++;
            } else
                $i = $sep + 1;
            $sep = -1;
            $j   = $i;
            $l   = 0;
            $nl++;
        } else
            $i++;
    }
    return $nl;
}

function row2_multiline($pdf, $label, $val1, $val2) {

    $wLabel  = 15;
    $wValue  = 80;
    $wLabel2 = 15;
    $wValue2 = 80;

    // Correct usage now allowed
    $h1 = $pdf->NbLines($wValue, $val1) * 5;
    $h2 = $pdf->NbLines($wValue2, $val2) * 5;

    $rowHeight = max($h1, $h2);

    $x = $pdf->GetX();
    $y = $pdf->GetY();

    $pdf->Cell($wLabel, $rowHeight, $label, 1);

    $pdf->MultiCell($wValue, 5, $val1, 1, 'L');

    $pdf->SetXY($x + $wLabel + $wValue, $y);

    $pdf->Cell($wLabel2, $rowHeight, $label, 1);

    $pdf->MultiCell($wValue2, 5, $val2, 1, 'L');
}

function wrapTwoLines($pdf, $text, $width) {
    // Split text into multiple lines automatically
    $lines = [];
    $words = explode(' ', $text);
    $current = '';

    foreach ($words as $w) {
        $test = trim($current . ' ' . $w);
        if ($pdf->GetStringWidth($test) < ($width - 2)) {
            $current = $test;
        } else {
            $lines[] = trim($current);
            $current = $w;
            if (count($lines) == 2) break; // stop at 2 lines
        }
    }

    if (count($lines) < 2) {
        $lines[] = trim($current);  // second line
    }

    // Ensure exactly two lines
    if (count($lines) == 1) $lines[] = "";

    return $lines;
}



row2($pdf, "Name:",    $row['customer'], $row['customer'], $rowHeight);
row2_multiline($pdf, "Address:", $cus['addr1'], $cus['addr1']);
row2($pdf, "State:",   $cus['state1'],   $cus['state1'],   $rowHeight);
row2($pdf, "GSTIN:",   $cus['gst'],      $cus['gst'],      $rowHeight);
row2($pdf, "PAN:",     $cus['cst'],      $cus['cst'],      $rowHeight);
row2($pdf, "Invoice:", $purch['invno'],  $purch['entrydate'], $rowHeight);

$pdf->Ln(4);

// ---------------------
// ITEMS TABLE
// ---------------------
$pdf->SetFont('Arial','B',8);

if ($row['vatorcst'] == 'INTRASTATE') {

    $header = ['Sl','Code','Part Name','HSN','Qty','Rate','Disc','Bef Tax','CGST%','CGST Amt','SGST%','SGST Amt','Total'];
    $widths = [5,20,25,20,10,15,13,15,10,15,12,15,15];

} else {

    $header = ['Sl','Code','Part Name','Qty','Rate','Disc','Bef Tax','IGST%','IGST Amt','Total'];
    $widths = [5,20,50,10,20,20,20,15,20,25];
}

// Header row
foreach ($header as $i => $h) {
    $pdf->Cell($widths[$i], 7, $h, 1, 0, 'C');
}
$pdf->Ln();

$pdf->SetFont('Arial','',8);

// Prevent overlap: track height
$lineHeight = 6;
$maxY = 260;  // Before totals block

$items = mysqli_query($db, "SELECT * FROM salesreturn WHERE retno='$invno' AND brcode='$brcode'");
$sl = 1;

$lineHeight = 5;
$twoLineHeight = $lineHeight * 2;

while($it = mysqli_fetch_assoc($items)) {

    // PAGE BREAK CHECK
    if ($pdf->GetY() + $twoLineHeight > $maxY) {
        $pdf->AddPage();

        // print header again
        $pdf->SetFont('Arial','B',10);
        foreach ($header as $i => $h) {
            $pdf->Cell($widths[$i], 7, $h, 1, 0, 'C');
        }
        $pdf->Ln();
        $pdf->SetFont('Arial','',9);
    }

    $partNameLines = wrapTwoLines($pdf, $it['partname'], $widths[2]);
    
    $partcode = $it['partcode']; 
    $hsn = mysqli_fetch_assoc(mysqli_query($db, "SELECT location FROM partmaster WHERE partcode='$partcode'"));

    $qty  = $it['qty'];
    $rate = $it['price'];
    $disc = round($qty * $rate * $it['disc'] / 100, 2);
    $beforeTax = $it['aprice'];
    $total = $it['tot'];

    $hsncode = $hsn['location'] ?? '';

    if ($row['vatorcst'] == 'INTRASTATE') {
        $data = [
            $sl++,
            $it['partcode'],
            $partNameLines,  // <-- ONLY this is array
            $hsncode,
            $qty,
            $rate,
            $disc,
            $beforeTax,
            $it['cgstp'],
            $it['cgstamt'],
            $it['sgstp'],
            $it['sgstamt'],
            $total
        ];
    } else {
        $data = [
            $sl++,
            $it['partcode'],
            $partNameLines, // <-- array
            $qty,
            $rate,
            $disc,
            $beforeTax,
            $it['igstp'],
            $it['igstamt'],
            $total
        ];
    }

    // ----- PRINT ROW -----
    $x = $pdf->GetX();
    $y = $pdf->GetY();

    foreach ($data as $i => $col) {

        $W = $widths[$i];

        // MULTILINE COLUMN (Part Name)
        if ($i === 2) {

            $pdf->Rect($x, $y, $W, $twoLineHeight);

            $pdf->SetXY($x, $y);

            $pdf->MultiCell($W, $lineHeight,
                $col[0] . "\n" . $col[1],
                0, 'L'
            );

        } else {
            // NORMAL COLUMNS (always strings)
            $pdf->SetXY($x, $y);
            $pdf->Cell($W, $twoLineHeight, (string)$col, 1, 0, 'R');
        }

        $x += $W;
    }

    $pdf->SetY($y + $twoLineHeight);
    $pdf->Ln(0);
}

$pdf->Ln(3);

// ---------------------
// TOTALS SECTION
// ---------------------
$pdf->SetFont('Arial','B',11);
$pdf->Cell(95, 7, "Prepared By: __________________", 0, 0);
$pdf->Cell(95, 7, "Verified By: __________________", 0, 1);

$pdf->Ln(2);

$pdf->SetFont('Arial','',11);
$pdf->Cell(120, 7, "Parts Total", 1, 0);
$pdf->Cell(70, 7, number_format($row['tot'],2), 1, 1);

$pdf->Cell(120, 7, "CGST Total", 1, 0);
$pdf->Cell(70, 7, $row['cgstamt'], 1, 1);

$pdf->Cell(120, 7, "SGST Total", 1, 0);
$pdf->Cell(70, 7, $row['sgstamt'], 1, 1);

$pdf->Cell(120, 7, "IGST Total", 1, 0);
$pdf->Cell(70, 7, $row['igstamt'], 1, 1);

$pdf->Cell(120, 7, "Net Amount", 1, 0);
$pdf->Cell(70, 7, number_format(round($row['tot']),2), 1, 1);

$pdf->Ln(3);

$pdf->SetFont('Arial','B',11);
$pdf->Cell(95, 7, "Signature of cashier: __________________", 0, 0);

// $pdf->Output();
$pdf->Output('D', 'spare_invoice_' . $invno . '.pdf', true);
?>
