/* jQuery jqEasyCharCounter plugin
 * Examples and documentation at: http://www.jqeasy.com/
 * Version: 1.0 (05/07/2010)
 * No license. Use it however you want. Just keep this notice included.
 * Requires: jQuery v1.3+
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
(function($) {

    $.fn.extend({
        jqEasyCounter: function(givenOptions) {
            return this.each(function() {
                var $this = $(this),
                    options = $.extend({
                        maxChars: 100,
                        maxCharsWarning: 80,
                        msgFontSize: '12px',
                        msgFontColor: '#000000',
                        msgFontFamily: 'Arial',
                        msgTextAlign: 'right',
                        msgWarningColor: '#F00',
                        msgAppendMethod: 'insertAfter',
                        allocateSpace: true
                    }, givenOptions);

                if(options.maxChars <= 0) return;

                /*
                // create counter element
                var jqEasyCounterMsg = $("<span class=\"jqEasyCounterMsg\">&nbsp;</span>");
                if (!options.allocateSpace){
                    jqEasyCounterMsg = $("<span class=\"jqEasyCounterMsg\"></span>");
                }

                var jqEasyCounterMsgStyle = {
                    'font-size' : options.msgFontSize,
                    'font-family' : options.msgFontFamily,
                    'color' : options.msgFontColor,
                    'text-align' : options.msgTextAlign,
                    'width' : $this.width()+10,
                    'paddingTop' : 2,
                    'paddingBottom' : 2,
                    'opacity' : 0
                };

                jqEasyCounterMsg.css(jqEasyCounterMsgStyle);
                // append counter element to DOM
                jqEasyCounterMsg[options.msgAppendMethod]($this);
                */

                // bind events to this element
                $this
                    .bind('keydown keyup keypress', doCount)
                    .bind('focus paste', function(){setTimeout(doCount, 10);});
                    //.bind('blur', function(){jqEasyCounterMsg.stop().fadeTo( 'fast', 0);return false;});

                function doCount(){
                    var val = $this.val(),
                        length = val.length;

                    if(length >= options.maxChars) {
                        val = val.substring(0, options.maxChars);
                    }

                    var icon = '';
                    if(length >= options.maxChars){
                        // keep scroll bar position
                        var originalScrollTopPosition = $this.scrollTop();
                        $this.val(val.substring(0, options.maxChars));
                        $this.scrollTop(originalScrollTopPosition);
                    }


                    /*
                    if(length >= options.maxCharsWarning){
                        jqEasyCounterMsg.css({"color" : options.msgWarningColor});
                        jqEasyCounterMsg.html(' Characters: ' + $this.val().length + "/" + options.maxChars);
                        jqEasyCounterMsg.stop().fadeTo( 'fast', 1);
                    } else {
                        // remove it
                        jqEasyCounterMsg.html(options.allocateSpace?'&nbsp;':'');
                    }
                    */
                }
            });
        }
    });

})(jQuery);