<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>AMPL Vehicle 25-26</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <style>
    * {
      box-sizing: border-box;
    }

    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background: linear-gradient(135deg, #1e3c72, #2a5298);
      background-size: 400% 400%;
      animation: gradientShift 12s ease infinite;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
    }

    @keyframes gradientShift {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }

    .login-card {
      background: rgba(255, 255, 255, 0.9);
      backdrop-filter: blur(10px);
      padding: 35px;
      border-radius: 16px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.25);
      width: 100%;
      max-width: 420px;
      transition: 0.3s ease;
    }

    .login-card:hover {
      transform: translateY(-4px);
    }

    .login-card img {
      display: block;
      margin: 0 auto 20px;
      width: 90px;
      height: auto;
    }

    .login-card h2 {
      text-align: center;
      font-size: 26px;
      color: #1e3c72;
      margin-bottom: 25px;
      font-weight: 600;
    }

    .login-card h2 span {
      color: orange;
    }

    .form-group {
      margin-bottom: 18px;
    }

    label {
      display: block;
      margin-bottom: 6px;
      color: #34495e;
      font-weight: 500;
      font-size: 15px;
    }

    input[type="text"],
    input[type="password"],
    select {
      width: 100%;
      padding: 10px 12px;
      border: 1px solid #ccc;
      border-radius: 8px;
      font-size: 15px;
      background-color: #f9f9f9;
      transition: 0.2s;
    }

    input[type="text"]:focus,
    input[type="password"]:focus,
    select:focus {
      border-color: #1e3c72;
      outline: none;
      background: #fff;
    }

    input[type="submit"] {
      background-color: #1e3c72;
      color: #fff;
      border: none;
      padding: 12px;
      border-radius: 8px;
      font-size: 16px;
      cursor: pointer;
      width: 100%;
      transition: background 0.3s ease;
      font-weight: 500;
    }

    input[type="submit"]:hover {
      background-color: #16305d;
    }

    .footer {
      margin-top: 25px;
      text-align: center;
      font-size: 13px;
      color: #444;
    }

    .footer a {
      color: #1e3c72;
      text-decoration: none;
      display: block;
      margin: 5px 0;
    }

    @media (max-width: 480px) {
      .login-card {
        padding: 25px 20px;
        margin: 0 10px;
      }
    }
  </style>
</head>
<body>
  <div class="login-card">
    <img src="images/logo.png" alt="Logo">
    <h2>AMPL <span>Vehicle</span> System</h2>
    <form name="f1" action="loginbranch.php" method="post">
      <div class="form-group">
        <label for="br">Branch</label>
        <select name="br" id="br" required>
          <?php
            include("opendb.php");
            $result = mysqli_query($db, "SELECT brname FROM branch WHERE brstate='Y' ORDER BY brname");
            while ($row = mysqli_fetch_row($result)) {
              echo "<option>$row[0]</option>";
            }
          ?>
        </select>
      </div>
      <div class="form-group">
        <label for="uname">User Name</label>
        <input type="text" name="uname" id="uname" required>
      </div>
      <div class="form-group">
        <label for="pswd">Password</label>
        <input type="password" name="pswd" id="pswd" required>
      </div>
      <input type="submit" value="Login">
    </form>
    <div class="footer">
      <p>Best viewed in Mozilla @ 1024x768</p>
      <a href="http://www.psninfotech.com">www.psninfotech.com</a>
      <a href="tel:+919895209122">+91 9895209122</a>
      <a href="tel:+919447779986">+91 9447779989</a>
    </div>
  </div>
</body>
</html>
