<?php
// ini_set('display_errors', 1);
session_start();
include("../opendb.php");
include("../test.php");
require("fpdf.php");

$invno = $_REQUEST['invno'];
$brcode = $_REQUEST['brcode'];

if ($invno === '') {
    die("Missing invno");
}

/* ------------------ Fetch DB rows (reuse your original logic) ------------------ */
$re = mysqli_query($db, "SELECT * FROM spareinvoice WHERE invno='$invno' AND brcode='$brcode'");
if (!$re || mysqli_num_rows($re) <= 0) {
    die("Invoice No does not exist");
}

$query1 = mysqli_query($db, "SELECT acfrom, acto FROM acperiod");
$per_row = mysqli_fetch_array($query1);

$jcrow = mysqli_fetch_array($re);
$maddr = $jcrow['addr'];

$foc = $_REQUEST['foc'] ?? '';
$invtype = $_REQUEST['invtype'] ?? '';

if ($foc == 'foc') {
    $re = mysqli_query($db, "select * from spareinvoicefoc where invno='$invno' and invtype='$invtype' and brcode='$brcode'") or die('err:' . mysqli_error($db));
} else {
    $re = mysqli_query($db, "select * from spareinvoice where invno='$invno' and brcode='$brcode'") or die(mysqli_error($db));
}
$row = mysqli_fetch_array($re) or die("Fetch Error:" . mysqli_error($db));
if ($row['entrydate'] > $per_row[1] || $row['entrydate'] < $per_row[0]) {
    die("Invoice not in this financial year !!!!!");
}

$brres = mysqli_query($db, "select * from branch where brcode='$brcode'");
$brrow = mysqli_fetch_array($brres);

$cusres = mysqli_query($db, "select * from customer where acname='" . mysqli_real_escape_string($db, $row['customer']) . "' and brcode='$brcode'");
$cusrow = mysqli_fetch_array($cusres);

$qrqry = mysqli_query($db, "select * from tbl_einvoice where invno='$row[invno]' and brcode='$brcode'");
$qrrow = mysqli_fetch_array($qrqry);
$signedqr = $qrrow['SignedQRCode'] ?? '';
$irn = $qrrow['irnno'] ?? '';

/* Fetch items and compute totals */
$res = mysqli_query($db, "select * from spareinvoice where invno='$invno' and brcode='$brcode'") or die(mysqli_error($db));
$items = [];
$partstotal = 0;
$total_disc = 0;
$totcshdis = 0;
$sgst_tot = 0;
$cgst_tot = 0;
$igst_tot = 0;
$qty_tot = 0;
$rate_tot = 0;
$i = 0;
while ($res1 = mysqli_fetch_assoc($res)) {
    $i++;
    $it = [];
    $it['slno'] = $i;
    $it['partcode'] = $res1['partcode'];
    $it['partname'] = $res1['partname'];
    $it['qty'] = $res1['qty'];
    $it['price'] = $res1['price'];
    $it['qtyprcamt'] = $res1['qty'] * $res1['price'];
    $partstotal += $it['qtyprcamt'];
    $it['disc'] = $res1['disc'];
    $it['discamt'] = ($it['qtyprcamt']) * $res1['disc'] / 100.0;
    $total_disc += $it['discamt'];
    $afterdis = $it['qtyprcamt'] - $it['discamt'];
    $it['cshdisc'] = $res1['cshdisc'];
    $it['cashdisamt'] = $afterdis * ($res1['cshdisc'] / 100.0);
    $totcshdis += $it['cashdisamt'];
    $qty_tot += $it['qty'];
    $rate_tot += $it['price'];

    // mrp and hsn lookup (best-effort)
    if ($brcode == 'YES001') {
        $sprqry = "select mrp from spareprmast_retail where partcode = '{$it['partcode']}' order by effectfrom desc limit 1";
    } else {
        $sprqry = "select mrp from spareprmast where partcode = '{$it['partcode']}' order by effectfrom desc limit 1";
    }
    $sprres = mysqli_query($db, $sprqry);
    $sprrow = mysqli_fetch_row($sprres);
    $it['mrp'] = $sprrow[0] ?? '';

    if ($brcode == 'YES001')
        $qry = "select location from  partmaster_retail where partcode='{$it['partcode']}'";
    else
        $qry = "select location from partmaster where partcode='{$it['partcode']}'";

    $rsqr = mysqli_query($db, $qry);
    $rsrw = mysqli_fetch_array($rsqr);
    $it['hsn'] = strlen($rsrw[0]) ? $rsrw[0] : '0';

    if ($row['vatorcst'] == 'INTRASTATE') {
        $it['cgstp'] = $res1['cgstp'];
        $it['sgstp'] = $res1['sgstp'];
        $it['cgstamt'] = $res1['cgstamt'];
        $it['sgstamt'] = $res1['sgstamt'];
        $sgst_tot += $res1['sgstamt'];
        $cgst_tot += $res1['cgstamt'];
        $it['taxable'] = $res1['aprice'];
    } else {
        $it['igstp'] = $res1['igstp'];
        $it['igstamt'] = $res1['igstamt'];
        $igst_tot += $res1['igstamt'];
        $it['taxable'] = $res1['aprice'];
    }

    $it['tot'] = $res1['tot'];
    $items[] = $it;
}

/* ------------------ Helper formatting functions ------------------ */
// function putcoma($num) {
//     return number_format((float)$num, 2, '.', ',');
// }

/* Rudimentary number to words (Indian) */
function numToWords($num) {
    $num = (int) round($num);
    if ($num === 0) return 'Zero';
    $ones = ['', 'One','Two','Three','Four','Five','Six','Seven','Eight','Nine','Ten','Eleven','Twelve','Thirteen','Fourteen','Fifteen','Sixteen','Seventeen','Eighteen','Nineteen'];
    $tens = ['', '', 'Twenty','Thirty','Forty','Fifty','Sixty','Seventy','Eighty','Ninety'];
    $units = ['', 'Thousand', 'Lakh', 'Crore'];
    $parts = [];
    $hundreds = $num % 1000;
    if ($hundreds) $parts[] = convertThreeDigit($hundreds);
    $num = intdiv($num, 1000);
    $unitIdx = 1;
    while ($num > 0) {
        $group = $num % 100;
        if ($group) {
            $prefix = convertTwoDigit($group);
            $parts[] = $prefix . ' ' . ($units[$unitIdx] ?? '');
        }
        $num = intdiv($num, 100);
        $unitIdx++;
    }
    return trim(implode(' ', array_reverse(array_filter(array_map('trim', $parts)))));
}
function convertThreeDigit($n) {
    $ones = ['', 'One','Two','Three','Four','Five','Six','Seven','Eight','Nine','Ten','Eleven','Twelve','Thirteen','Fourteen','Fifteen','Sixteen','Seventeen','Eighteen','Nineteen'];
    $tens = ['', '', 'Twenty','Thirty','Forty','Fifty','Sixty','Seventy','Eighty','Ninety'];
    $out = '';
    if ($n >= 100) {
        $out .= $ones[intval($n / 100)] . ' Hundred ';
        $n = $n % 100;
    }
    if ($n > 0) {
        if ($n < 20) $out .= $ones[$n];
        else $out .= $tens[intval($n / 10)] . ' ' . $ones[$n % 10];
    }
    return trim($out);
}
function convertTwoDigit($n) {
    $ones = ['', 'One','Two','Three','Four','Five','Six','Seven','Eight','Nine','Ten','Eleven','Twelve','Thirteen','Fourteen','Fifteen','Sixteen','Seventeen','Eighteen','Nineteen'];
    $tens = ['', '', 'Twenty','Thirty','Forty','Fifty','Sixty','Seventy','Eighty','Ninety'];
    if ($n < 20) return $ones[$n];
    return $tens[intval($n / 10)] . ' ' . $ones[$n % 10];
}

/* ------------------ FPDF layout & drawing ------------------ */
/* We'll use Landscape A4 to match your wide table in screenshots */
class PDF extends FPDF {
    // convenience: draw table cell with border and center or right align
    function cellFit($w, $h, $txt, $border = 0, $ln = 0, $align = 'L') {
        $this->Cell($w, $h, $txt, $border, $ln, $align);
    }
    function Footer() {
        // page number at bottom-right (we'll also draw footer content manually)
        $this->SetY(-12);
        $this->SetFont('Arial', '', 8);
        $this->Cell(0, 6, 'Page '.$this->PageNo().'/{nb}', 0, 0, 'R');
    }
}

/* instantiate PDF */
$pdf = new PDF('L', 'mm', 'A4');
$pdf->AliasNbPages();
$pdf->SetAutoPageBreak(false); // we'll manage footer location manually
$pdf->SetMargins(8, 8, 8);
$leftMargin  = 8;
$rightMargin = 8;
$topMargin   = 8;

$pdf->SetFont('Arial', '', 9);

$limit = 22; // items per page (same as your html)
$total_items = count($items);
$pg_no = max(0, (int) floor(($total_items - 1) / $limit));

/* Pre-download QR if exists using cURL (allows allow_url_fopen=0) */
$qr_temp = '';
if (!empty($signedqr)) {
    $qr_url = "https://qrcode.tec-it.com/API/QRCode?size=small&dpi=150&data=" . urlencode($signedqr);
    $qr_temp = sys_get_temp_dir() . '/qr_' . md5($signedqr) . '.png';
    $ch = curl_init($qr_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $qr_data = curl_exec($ch);
    $http_status = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
    curl_close($ch);
    if ($qr_data !== false && $http_status >= 200 && $http_status < 300) {
        file_put_contents($qr_temp, $qr_data);
    } else {
        $qr_temp = ''; // fallback if download fails
    }
}

/* Column widths (landscape A4: width ~ 297mm - margins)
   These widths are tuned to fit many columns like your screenshot.
   Adjust small values if numbers overflow.
*/
$col = [
    'sl' => 8,
    'partcode' => 20,
    'partname' => 50,
    'hsn' => 18,
    'qty' => 12,
    'rate' => 18,
    'mrp' => 14,
    'disc%' => 12,
    'discamt' => 20,
    'cashdisc' => 18,
    'taxable' => 22,
    // tax columns
    'tax1p' => 12,
    'tax1amt' => 20,
    'tax2p' => 12,
    'tax2amt' => 20,
    'total' => 22
];

for ($p = 0; $p <= $pg_no; $p++) {
    $pdf->AddPage();
    $pdf->SetFont('Arial', '', 9);
    $left = $pdf->GetX();
    $topY = $pdf->GetY();

    // Header: AUTOSPEC logo centered and QR top-right
    // logo centered
    $logo_h = 18;
    $logo_path = __DIR__ . '/images/autospec_logo.jpeg';
    if (file_exists($logo_path)) {
        $pdf->Image($logo_path, ($pdf->GetPageWidth() - 40) / 2, 8, 40, $logo_h);
    } else {
        // fallback: print text
        $pdf->SetY(10);
        $pdf->SetFont('Arial', 'B', 16);
        $pdf->Cell(0, 8, 'AUTOSPEC', 0, 1, 'C');
    }

    // IRN left top area
    $pdf->SetY(12);
    $pdf->SetFont('Arial', '', 9);
    if (!empty($irn)) {
        $pdf->SetX(10);
        $pdf->MultiCell(150, 5, "IRN: $irn", 0);
    }

    // QR top-right if downloaded
    if (!empty($qr_temp) && file_exists($qr_temp)) {
        $pdf->Image($qr_temp, $pdf->GetPageWidth() - 40, 8, 32, 32);
    }

    // Title row (INVNO & FORM GST INV)
    $pdf->SetY(30);
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(80, 8, "INVNO: " . ($invno), 1, 0, 'L');
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->Cell(0, 8, "FORM GST INV - 1", 1, 1, 'C'); // takes rest width
    // Pay type label inside same header row on right
    $y_after = $pdf->GetY();
    $pdf->SetXY($pdf->GetPageWidth() - 100, 30);
    $pdf->SetFont('Arial', '', 10);
    $invdt = date('d-m-Y', strtotime($row['entrydate']));
    $pdf->Cell(90, 8, "INVDT: $invdt", 1, 1, 'R');
    $pdf->SetY($y_after + 2);

    // Billing and shipping boxes - two columns
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->SetXY(10, $pdf->GetY() + 2);
    $pdf->Cell(140, 6, 'Details of Receiver (Billed to)', 1, 0, 'L');
    $pdf->Cell(140, 6, 'Details of Consignee (Shipped to)', 1, 1, 'L');

    $pdf->SetFont('Arial', '', 9);
    $billing = $row['customer'] . "\n" . ($row['addr1'] ? $row['addr1'] : $maddr);
    if (!empty($cusrow['pin1'])) $billing .= " PIN:" . $cusrow['pin1'];
    if (!empty($cusrow['phone1'])) $billing .= " PHONE:" . $cusrow['phone1'];

    $curY = $pdf->GetY();
    $pdf->MultiCell(140, 5, "Name : " . $row['customer'] . "\nAddress : " . $billing . "\nState : " . ($cusrow['state1'] ?: $row['invtype']) . "\nGSTIN : " . ($cusrow['gst'] ?: '') . "\nPAN : " . ($cusrow['cst'] ?: ''), 1);
    // move to right column (shipper) - mirror content
    $pdf->SetXY(150, $curY);
    $pdf->MultiCell(140, 5, "Name : " . $row['customer'] . "\nAddress : " . $billing . "\nState : " . ($cusrow['state1'] ?: $row['invtype']) . "\nGSTIN : " . ($cusrow['gst'] ?: '') . "\nPAN : " . ($cusrow['cst'] ?: ''), 1);

    $pdf->Ln(2);

    // Items table header
    $pdf->SetFont('Arial', 'B', 8);
    $startX = 10;
    $pdf->SetX($startX);
    $pdf->Cell($col['sl'], 8, 'SLNO', 1, 0, 'C');
    $pdf->Cell($col['partcode'], 8, 'PARTCODE', 1, 0, 'C');
    $pdf->Cell($col['partname'], 8, 'PART NAME', 1, 0, 'C');
    $pdf->Cell($col['hsn'], 8, 'HSN CODE', 1, 0, 'C');
    $pdf->Cell($col['qty'], 8, 'QTY', 1, 0, 'C');
    $pdf->Cell($col['rate'], 8, 'RATE', 1, 0, 'C');
    $pdf->Cell($col['mrp'], 8, 'MRP', 1, 0, 'C');
    $pdf->Cell($col['disc%'], 8, 'DISC%', 1, 0, 'C');
    $pdf->Cell($col['discamt'], 8, 'DISC AMT', 1, 0, 'C');
    $pdf->Cell($col['cashdisc'], 8, 'CASH DISC', 1, 0, 'C');
    $pdf->Cell($col['taxable'], 8, 'TAXABLE VALUE', 1, 0, 'C');
    // taxes & totals (intrastate has CGST+SGST, interstate has IGST)
    if ($row['vatorcst'] == 'INTRASTATE') {
        $pdf->Cell($col['tax1p'], 8, 'CGST %', 1, 0, 'C');
        $pdf->Cell($col['tax1amt'], 8, 'CGST AMT', 1, 0, 'C');
        $pdf->Cell($col['tax2p'], 8, 'SGST %', 1, 0, 'C');
        $pdf->Cell($col['tax2amt'], 8, 'SGST AMT', 1, 0, 'C');
    } else {
        $pdf->Cell($col['tax1p'], 8, 'IGST %', 1, 0, 'C');
        $pdf->Cell($col['tax1amt'], 8, 'IGST AMT', 1, 0, 'C');
    }
    $pdf->Cell($col['total'], 8, 'TOTAL AMT', 1, 1, 'C');

    // Items rows - for this page
    $pdf->SetFont('Arial', '', 8);
    $start = $p * $limit;
    $end = min($start + $limit, $total_items);
    // draw rows; if fewer than limit, fill with empty rows so footer sits fixed
    for ($i = 0; $i < $limit; $i++) {
        $k = $start + $i;
        $isEmpty = ($k >= $total_items);
        $it = $isEmpty ? null : $items[$k];

        $pdf->SetX($startX);
        $pdf->Cell($col['sl'], 7, $isEmpty ? '' : $it['slno'], 1, 0, 'C');
        $pdf->Cell($col['partcode'], 7, $isEmpty ? '' : $it['partcode'], 1, 0);
        $pdf->Cell($col['partname'], 7, $isEmpty ? '' : (substr($it['partname'], 0, 70)), 1, 0);
        $pdf->Cell($col['hsn'], 7, $isEmpty ? '' : $it['hsn'], 1, 0, 'C');
        $pdf->Cell($col['qty'], 7, $isEmpty ? '' : $it['qty'], 1, 0, 'R');
        $pdf->Cell($col['rate'], 7, $isEmpty ? '' : putcoma($it['price']), 1, 0, 'R');
        $pdf->Cell($col['mrp'], 7, $isEmpty ? '' : $it['mrp'], 1, 0, 'R');
        $pdf->Cell($col['disc%'], 7, $isEmpty ? '' : $it['disc'], 1, 0, 'R');
        $pdf->Cell($col['discamt'], 7, $isEmpty ? '' : putcoma($it['discamt']), 1, 0, 'R');
        $pdf->Cell($col['cashdisc'], 7, $isEmpty ? '' : putcoma($it['cashdisamt']), 1, 0, 'R');
        $pdf->Cell($col['taxable'], 7, $isEmpty ? '' : putcoma($it['taxable']), 1, 0, 'R');

        if ($row['vatorcst'] == 'INTRASTATE') {
            $pdf->Cell($col['tax1p'], 7, $isEmpty ? '' : ($it['cgstp'] ?? ''), 1, 0, 'R');
            $pdf->Cell($col['tax1amt'], 7, $isEmpty ? '' : putcoma($it['cgstamt'] ?? 0), 1, 0, 'R');
            $pdf->Cell($col['tax2p'], 7, $isEmpty ? '' : ($it['sgstp'] ?? ''), 1, 0, 'R');
            $pdf->Cell($col['tax2amt'], 7, $isEmpty ? '' : putcoma($it['sgstamt'] ?? 0), 1, 0, 'R');
        } else {
            $pdf->Cell($col['tax1p'], 7, $isEmpty ? '' : ($it['igstp'] ?? ''), 1, 0, 'R');
            $pdf->Cell($col['tax1amt'], 7, $isEmpty ? '' : putcoma($it['igstamt'] ?? 0), 1, 0, 'R');
        }

        $pdf->Cell($col['total'], 7, $isEmpty ? '' : putcoma($it['tot']), 1, 1, 'R');
    }

    // After items: DSR / PREPARED BY / Accounts Totals box on right -- Footer area
    // Position footer block near bottom (approx Y = 200mm from top for landscape A4)
    $footerY = 180; // tweak if needed
    $pdf->SetY($footerY);
    $pdf->SetFont('Arial', '', 9);

    // Left two small cells: DSR and Prepared By (like your HTML)
    $pdf->Cell(120, 6, 'DSR : ' . ($row['engineer'] ?? ''), 0, 0, 'L');
    $pre_by1 = explode("|", $row['ref'] ?? '');
    $pre_by = $pre_by1[1] ?? '';
    $pdf->Cell(120, 6, 'PREPARED BY : ' . trim($pre_by), 0, 1, 'L');

    // Big footer - left company info + PSN logo; right accounts box
    // Left block width about 180mm; right totals about 100mm
    $leftBlockW = 190;
    // $rightBlockW = $pdf->GetPageWidth() - $pdf->lMargin - $pdf->rMargin - $leftBlockW - 6;
    $rightBlockW = $pdf->GetPageWidth() - $leftMargin - $rightMargin - $leftBlockW - 6;

    // Left block: Company details and PSN logo image
    $yBefore = $pdf->GetY();
    $pdf->SetX(10);
    $pdf->MultiCell($leftBlockW, 5, "PSN AUTOMOTIVE MARKETING PRIVATE LIMITED\n" . ($brrow['braddr'] ?? '') . ", " . ($brrow['brcity'] ?? '') . "\nGSTIN: " . ($brrow['tin'] ?? '') . "\nPhone : 080-45313910\nEmail : info@autospec.in", 0);
    // place PSN logo below leftBlock text
    $logo2 = __DIR__ . '/images/psn_logo_400.png';
    if (file_exists($logo2)) {
        // calculate y to place image to left bottom area
        $imgY = $yBefore + 6;
        $pdf->Image($logo2, 12, $imgY + 10, 40); // adjust size/position as needed
    }

    // Right block: Totals box
    $pdf->SetXY(10 + $leftBlockW + 6, $yBefore);
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Cell($rightBlockW, 6, 'ACCOUNTS', 1, 1, 'C');
    $pdf->SetFont('Arial', '', 9);
    $pdf->Cell($rightBlockW - 60, 6, 'PARTS TOTAL', 1, 0);
    $pdf->Cell(60, 6, putcoma($partstotal), 1, 1, 'R');

    $pdf->Cell($rightBlockW - 60, 6, 'DISCOUNT', 1, 0);
    $pdf->Cell(60, 6, putcoma($total_disc), 1, 1, 'R');

    $pdf->Cell($rightBlockW - 60, 6, 'CASH DISCOUNT', 1, 0);
    $pdf->Cell(60, 6, putcoma($totcshdis), 1, 1, 'R');

    if ($row['vatorcst'] == 'INTRASTATE') {
        $pdf->Cell($rightBlockW - 60, 6, 'CGST TOTAL', 1, 0);
        $pdf->Cell(60, 6, putcoma($cgst_tot), 1, 1, 'R');
        $pdf->Cell($rightBlockW - 60, 6, 'SGST TOTAL', 1, 0);
        $pdf->Cell(60, 6, putcoma($sgst_tot), 1, 1, 'R');
    } else {
        $pdf->Cell($rightBlockW - 60, 6, 'IGST TOTAL', 1, 0);
        $pdf->Cell(60, 6, putcoma($igst_tot), 1, 1, 'R');
    }

    $jtot = array_sum(array_column($items, 'tot'));
    $dif1 = round($jtot);
    $dif = round(($dif1 - $jtot), 2);
    $pdf->Cell($rightBlockW - 60, 6, 'ROUND OFF', 1, 0);
    $pdf->Cell(60, 6, putcoma($dif), 1, 1, 'R');

    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell($rightBlockW - 60, 8, 'NET AMOUNT', 1, 0);
    $pdf->Cell(60, 8, putcoma(round($jtot)), 1, 1, 'R');

    $pdf->Ln(3);
    $pdf->SetFont('Arial', '', 9);
    $pdf->MultiCell($leftBlockW, 6, 'RUPEES ' . strtoupper(numToWords(round($jtot))) . ' ONLY', 0);

    // Receiver signature placeholder right of left block
    $pdf->SetXY(10 + $leftBlockW + 6, $pdf->GetY());
    $pdf->Cell($rightBlockW, 6, 'RECEIVER SIGNATURE', 0, 1, 'C');

    // Bank details under left block
    $pdf->SetXY(10, $pdf->GetY() + 4);
    $pdf->MultiCell($leftBlockW, 5, "Bank Details: PSN AUTOMOTIVE MARKETING PVT. LTD\nBRANCH : BANK OF BARODA, STJOHNS MEDICAL COLLEGE, BANGALORE BRANCH\nA/C NO. 05210200001133\nIFSC Code. BARB0STJOHN", 0);

    // Page footer handled by Footer() - but also print the Page: X/Y bottom right
    $pdf->SetY(-18);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(0, 6, 'Page: ' . ($p + 1) . '/' . ($pg_no + 1), 0, 0, 'R');
}

/* Stream PDF inline to browser */
$filename = "invoice_{$invno}.pdf";

// If you also want to save to server uncomment below:
// $savePath = $_SERVER["DOCUMENT_ROOT"] . '/force2526/paypdf/custfolder/' . $filename;
// $pdf->Output('F', $savePath);

// Output inline
$pdf->Output('I', $filename);

/* cleanup QR temp file */
if (!empty($qr_temp) && file_exists($qr_temp)) {
    @unlink($qr_temp);
}
exit;
?>


