<?php
ini_set('display_errors',1);
session_start();
include("../opendb.php");
// require("fpdf/fpdf.php");

$invno = $_REQUEST['invno'];
$brcode = $_REQUEST['brcode'];

// ===== Branch & Invoice Master =====
$brres = mysqli_query($db,"SELECT * FROM branch WHERE brcode='$brcode'");
$brrow = mysqli_fetch_array($brres);

$re = mysqli_query($db,"SELECT * FROM spareinvoice WHERE invno='$invno' AND brcode='$brcode'");
if(mysqli_num_rows($re) <= 0){
    die("Invoice not found!");
}
$row = mysqli_fetch_array($re);

// ===== Customer =====
$cusres = mysqli_query($db,"SELECT * FROM customer WHERE acname='".$row['customer']."' AND brcode='$brcode'");
$cusrow = mysqli_fetch_array($cusres);

// ===== PDF Init =====
$pdf = new FPDF('P','mm','A4');
$pdf->AddPage();
$pdf->SetFont('Arial','',10);

// ===== Header =====
$pdf->Image('../images/psnlogo.jpg',10,6,30);
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,6,"PSN AUTOMOTIVE MARKETING PVT LTD",0,1,'C');
$pdf->SetFont('Arial','',9);
$pdf->Cell(0,6,"GSTIN: ".$brrow['tin'],0,1,'C');
$pdf->Ln(5);

// ===== Invoice Header =====
$pdf->SetFont('Arial','',10);
$pdf->Cell(95,6,"Invoice No: ".$row['invno'],0,0,'L');
$pdf->Cell(95,6,"Date: ".date("d-m-Y", strtotime($row['entrydate'])),0,1,'R');
$pdf->Ln(4);

// ===== Customer / Consignee =====
$pdf->SetFont('Arial','B',9);
$pdf->Cell(95,6,"Billed To",1,0,'C');
$pdf->Cell(95,6,"Shipped To",1,1,'C');
$pdf->SetFont('Arial','',8);

$billto = $row['customer']."\n".
          $cusrow['addr1'].", ".$cusrow['dist1'].", ".$cusrow['pin1']."\n".
          "GST: ".$cusrow['gst']."\nPAN: ".$cusrow['cst'];

$shipto = ($row['shipto'] ?: $row['customer'])."\n".
          ($row['shipaddr'] ?: $cusrow['addr1'].", ".$cusrow['dist1'].", ".$cusrow['pin1'])."\n".
          "GST: ".$cusrow['gst']."\nPAN: ".$cusrow['cst'];

// Capture positions
$y = $pdf->GetY();
$pdf->MultiCell(95,5,$billto,1);
$pdf->SetXY(105,$y);
$pdf->MultiCell(95,5,$shipto,1);
$pdf->Ln(5);

// ===== Items Table =====
$pdf->SetFont('Arial','B',8);
$cols = [
    ['Sl',8],
    ['Part No',20],
    ['Part Name',45],
    ['Qty',12],
    ['Price',20],
    ['Disc %',15],
    ['Total',25],
];
foreach($cols as $col){
    $pdf->Cell($col[1],7,$col[0],1,0,'C');
}
$pdf->Ln();

$pdf->SetFont('Arial','',8);
$res_items = mysqli_query($db,"SELECT * FROM spareinvoice WHERE invno='$invno' AND brcode='$brcode'");
$i=1; $grandtotal=0;
while($item = mysqli_fetch_array($res_items)){
    $total = $item['tot'];
    $grandtotal += $total;

    $pdf->Cell(8,6,$i,1);
    $pdf->Cell(20,6,$item['partcode'],1);
    $pdf->Cell(45,6,substr($item['partname'],0,25),1);
    $pdf->Cell(12,6,$item['qty'],1,0,'C');
    $pdf->Cell(20,6,number_format($item['price'],2),1,0,'R');
    $pdf->Cell(15,6,$item['disc'],1,0,'R');
    $pdf->Cell(25,6,number_format($total,2),1,1,'R');

    $i++;
}

// ===== Totals =====
$pdf->Ln(5);
$pdf->SetFont('Arial','B',10);
$pdf->Cell(140,7,'Net Amount',1,0,'R');
$pdf->Cell(50,7,number_format(round($grandtotal),2),1,1,'R');

// ===== Footer =====
$pdf->Ln(10);
$pdf->SetFont('Arial','',8);
$pdf->MultiCell(0,5,
"Bank Details: PSN Automotive Marketing Pvt. Ltd
Branch: Bank of Baroda, StJohns Medical College, Bangalore
A/c No: 05210200001133
IFSC: BARB0STJOHN",0,'L');

// ===== Output =====
$pdf->Output("I","invoice_$invno.pdf");
?>
